package com.biz.crm.eunm.sfa;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lf
 * @describe 计算薪资日期日志表实体类
 * @project crm
 * @package com.biz.crm.eunm.sfa
 * @date 2020/12/30 15:52
 */
public class SfaActivityEnum {

    /**
     * 活动类型
     */
    public enum activityType {
        COST_ACTIVITY("0", "费用活动"),
        DISPLAY_ACTIVITY("1", "陈列活动"),
        ;
        private String val;
        private String desc;

        activityType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (activityType type : activityType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 活动状态
     */
    public enum activityStatus {
        NOT_START("0", "未开始"),
        ALREADY_START("1", "已开始"),
        ALREADY_END("2","已结束"),
        ;
        private String val;
        private String desc;

        activityStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (activityStatus type : activityStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }

    /**
     * 活动要求
     */
    public enum activityRequire {
        ACTIVITY_PIC("0", "活动照"),
        DOOR_PIC("1", "门头照"),
        DISPLAY_PIC("2","陈列照"),
        ;
        private String val;
        private String desc;

        activityRequire(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (activityRequire type : activityRequire.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }


    /**
     * 活动范围类型
     */
    public enum rangeType {
        ORG("0", "组织"),
        CHANNEL("1", "渠道"),
        CUSTOMER("2","客户"),
        ;
        private String val;
        private String desc;

        rangeType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (rangeType type : rangeType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }



}
