package com.biz.crm.exception.tpm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * @Project crm
 * @PackageName com.biz.crm.exception.tpm
 * @ClassName CostTypeFineException
 * @Author HuangLong
 * @Date 2020/9/2 11:04
 * @Description 活动细类异常枚举
 */
public enum CostTypeFineException implements CrmExceptionType {

    DATA_NOT_EXIST("tpm_50001","活动细类数据不存在"),
    DATA_DUPLICATE("tpm_50002","活动细类数据重复,请检查"),
    DATA_CODE_DUPLICATE("tpm_50002","活动细类编码已存在,请检查"),

    ;

    private String code;
    private String description;

    CostTypeFineException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
