package com.biz.crm.eunm;

import com.biz.crm.base.BusinessException;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:文件类型
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum FileTypeEnum {
    PICTURE("picture","图片"),
    VIDEO("video","视频");

    private String code;
    private String des;

    FileTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (FileTypeEnum productTypeEnum : FileTypeEnum.values()) {
            codes.add(productTypeEnum.getCode());
        }
        return codes;
    }
}
