package com.biz.crm.exception.mdm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * @Project crm
 * @PackageName com.biz.crm.exception.mdm
 * @ClassName MdmCusMaterialException
 * @Author HuangLong
 * @Date 2020/9/2 11:04
 * @Description 客户物料异常枚举类
 */
public enum MdmCusMaterialException implements CrmExceptionType {

    DATA_NOT_EXIST("mdm_20001","客户物料数据不存在"),
    DATA_DUPLICATE("mdm_20001","已存在生效的客户物料数据"),
    ;

    private String code;
    private String description;

    MdmCusMaterialException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
