package com.biz.crm.eunm;

import com.biz.crm.base.BusinessException;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:crm数据业务状态
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum ProductTypeEnum {
    STANDARD("standard","标准商品"),
    GIFT_PACKAGE("gift_package","礼包商品"),
    RANGE("range","范围商品");

    private String code;
    private String des;

    ProductTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * code转数组
     * @return
     */
    public static Set<String> codeToSet(){
        Set<String> codes = new HashSet<>();
        for (ProductTypeEnum productTypeEnum : ProductTypeEnum.values()) {
            codes.add(productTypeEnum.getCode());
        }
        return codes;
    }
}
