package com.biz.crm.eunm.tpm;

import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:crm 活动发送消息的类型
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum ActSendMessageTypeEnum {
    APPROVED("approved","审批通过"),
    CLOSED("closed","活动关闭"),
    ALL_AUDIT("all_audit","活动明细完全核销")
    ;



    private String code;
    private String des;

    ActSendMessageTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    public static String getStatusName(String code){
        ActSendMessageTypeEnum[] values = ActSendMessageTypeEnum.values();
        String desc=null;
        for (ActSendMessageTypeEnum o : values){
            if(StringUtils.equals(o.getCode(),code)){
                desc=o.getDes();
                break;
            }
        }
        return desc;
    }
}
