package com.biz.crm.eunm.upload;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description:
 * @project：crm
 * @package：com.biz.crm.eunm.upload
 * @author：lifei
 * @create：2020/12/9 1:37 下午
 */
public class UploadEnum {

    /**
     * 文件状态
     */
    public enum fileStatus {
        //导出
        EXPORT_FAIL("7","失败"),
        EXPORT_SUCCESS("8","成功"),
        EXPORT_IN_EXECUTION("9","执行中"),

        //导入
        IMPORT_FAIL("3","失败"),
        IMPORT_SUCCESS("4","成功"),
        IMPORT_IN_EXECUTION("5","执行中"),
        IMPORT_EXCEPTION("6","异常")
        ;
        private String val;
        private String desc;

        fileStatus(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (fileStatus type : fileStatus.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }


    }

    public enum fileType{
        EXPORT("1","导出"),
        IMPORT("0","导入"),

        ;
        private String val;
        private String desc;

        fileType(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (fileType type : fileType.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }


    }

    public enum userName{
        ADMIN("admin","超级管理员"),;
        private String val;
        private String desc;

        userName(String val, String desc) {
            this.val = val;
            this.desc = desc;
        }

        public static Map<String, String> GETMAP = new HashMap<>();

        static {
            for (userName type : userName.values()) {
                GETMAP.put(type.getVal(), type.getDesc());
            }
        }

        public String getVal() {
            return val;
        }

        public void setVal(String val) {
            this.val = val;
        }

        public String getDesc() {
            return desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }


    }
}
