package com.biz.crm.wx;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.util.Result;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.wx
 * @Description: TODO
 * @date 2020/12/29 下午2:31
 */
public class WxMsgUtil {
    public static final String markdown = "markdown";
    private static final String  wxUrl = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=e6170edb-0633-4601-ad0e-7c9ec4dc834f";

    public static void sendMarkdownMsg(String msg){
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype",markdown);
        JSONObject markdown = new JSONObject();
        markdown.put("content",msg);
        jsonObject.put("markdown",markdown);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        ResponseEntity<Result> response = RestTemplateUtils.postForEntity(wxUrl, headers, jsonObject, Result.class);
    }

    public static void sendTextMsg(String msg){
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype","text");
        JSONObject text = new JSONObject();
        text.put("content",msg);
        jsonObject.put("text",text);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        ResponseEntity<Result> response = RestTemplateUtils.postForEntity(wxUrl, headers, jsonObject, Result.class);
    }


}
