package com.biz.crm.exception.tpm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * @Project crm
 * @PackageName com.biz.crm.exception.tpm
 * @ClassName BudgetSubjectsException
 * @Author HuangLong
 * @Date 2020/9/2 11:04
 * @Description 预算科目异常枚举
 */
public enum BudgetSubjectsException implements CrmExceptionType {

    DATA_NOT_EXIST("tpm_20001","预算科目数据不存在"),
    DATA_DUPLICATE("tpm_20002","预算科目数据重复,请检查"),
    ;

    private String code;
    private String description;

    BudgetSubjectsException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
