package com.biz.crm.util;

import org.springframework.beans.BeanUtils;

import java.beans.PropertyDescriptor;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 对象处理
 *
 * @Author huang.long
 * @Date Created in 2020-03-12 10:15
 */
public class CrmBeanUtil {
    /**
     * 复制bean的属性
     *
     * @param source 源 要复制的对象
     * @param target 目标 复制到此对象
     */
    public static void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties(source, target);
    }

    /**
     * 复制对象
     *
     * @param source 源 要复制的对象
     * @param target 目标 复制到此对象
     * @param <T>
     * @return
     */
    public static <T> T copy(Object source, Class<T> target) {
        if (source==null) {
            return null;
        }
        try {
            T newInstance = target.newInstance();
            BeanUtils.copyProperties(source, newInstance);
            return newInstance;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 复制list
     *
     * @param source
     * @param target
     * @param <T>
     * @param <K>
     * @return
     */
    public static <T, K> List<K> copyList(List<T> source, Class<K> target) {

        if (null == source || source.isEmpty()) {
            return Collections.emptyList();
        }
        return source.stream().map(e -> copy(e, target)).collect(Collectors.toList());
    }

    /**
     * 复制bean的扩展字段1~10
     *
     * @param source 源 要复制的对象
     * @param target 目标 复制到此对象
     */
    public static void copyExt10(Object source, Object target) {
        if (source == null || target == null) {
            return;
        }
        Set<String> props = new HashSet<>(16);
        for (int i = 1; i <= 10; i++) {
            props.add("ext" + i);
        }
        String[] filteredPropertyNames =
                Arrays.stream(BeanUtils.getPropertyDescriptors(source.getClass()))
                        .map(PropertyDescriptor::getName)
                        .filter(item -> !props.contains(item))
                        .toArray(String[]::new);
        if (filteredPropertyNames.length > 0) {
            BeanUtils.copyProperties(source, target, filteredPropertyNames);
        }
    }

    /**
     * 复制bean的扩展字段1~50
     *
     * @param source 源 要复制的对象
     * @param target 目标 复制到此对象
     */
    public static void copyExt50(Object source, Object target) {
        if (source == null || target == null) {
            return;
        }
        Set<String> props = new HashSet<>(64);
        for (int i = 1; i <= 50; i++) {
            props.add("ext" + i);
        }
        String[] filteredPropertyNames =
                Arrays.stream(BeanUtils.getPropertyDescriptors(source.getClass()))
                        .map(PropertyDescriptor::getName)
                        .filter(item -> !props.contains(item))
                        .toArray(String[]::new);
        if (filteredPropertyNames.length > 0) {
            BeanUtils.copyProperties(source, target, filteredPropertyNames);
        }
    }
}
