package com.biz.crm.util.cache;

import com.biz.crm.base.BusinessException;
import com.biz.crm.common.param.RedisParam;
import com.biz.crm.service.RedisService;

/**
 * 页面配置缓存工具类
 *
 * @author zxw
 * @date 2021-01-18 15:45
 **/
public class TableConfigUtil {

    private static RedisService redisService;

    public static void setRedisService(RedisService redis) {
        redisService = redis;
    }

    public static Object getTableConfig(String functionCode,String listConfigCode){
        return redisService.get(generatedKey(functionCode, listConfigCode));
    }

    public static void setTableConfig(String functionCode,String listConfigCode,Object obj) {
        redisService.setDays(generatedKey(functionCode, listConfigCode), obj, 10);
    }

    public static void removeListConfig(String functionCode, String listConfigCode) {
        redisService.del(generatedKey(functionCode,listConfigCode));
    }

    public static void removeFunction(String functionCode) {
        redisService.delBatch(generatedKey(functionCode));
    }

    public static void removeAll() {
        redisService.delBatch(generatedKey());
    }

    public static String generatedKey(String functionCode, String listConfigCode) {
        if (functionCode == null || "".equals(functionCode.trim())) {
            throw new BusinessException("菜单编码不能为空");
        }
        if (listConfigCode == null || "".equals(listConfigCode.trim())) {
            throw new BusinessException("功能编码不能为空");
        }
        return RedisParam.TABLE_CONFIG + functionCode + ":" + listConfigCode;
    }

    public static String generatedKey(String functionCode) {
        if (functionCode == null || "".equals(functionCode.trim())) {
            throw new BusinessException("菜单编码不能为空");
        }
        return RedisParam.TABLE_CONFIG + functionCode + ":*";
    }

    public static String generatedKey() {
        return RedisParam.TABLE_CONFIG + "*";
    }

}
