package com.biz.crm.eunm.tpm;

import java.util.HashSet;
import java.util.Set;

/**
 * @Description:crm 活动预付类型枚举
 * @Author: huanglong
 * @Date: 2020/8/20 18:25
 **/
public enum TpmSaveTypeEnum {
    ONLY_NEW("1","新增暂存"),
    NEW_APPROVE("2","新增并提交审批"),
    ONLY_UPDATE("3","修改暂存"),
    UPDATE_APPROVE("4","修改并提交审批"),
    ONLY_APPROVE("5","提交审批"),
    ;



    private String code;
    private String des;

    TpmSaveTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return code;
    }

    public String getDes() {
        return des;
    }

    /**
     * 获取可以发起审批的类型集合
     * @return
     */
    public static Set<String> getCanSendToActivityTypes(){
        Set<String> set=new HashSet<String>();
        set.add(TpmSaveTypeEnum.NEW_APPROVE.getCode());
        set.add(TpmSaveTypeEnum.UPDATE_APPROVE.getCode());
        set.add(TpmSaveTypeEnum.ONLY_APPROVE.getCode());
        return set;
    }
    /**
     * 获取待提交的类型集合
     * @return
     */
    public static Set<String> getCreateTypes(){
        Set<String> set=new HashSet<String>();
        set.add(TpmSaveTypeEnum.ONLY_NEW.getCode());
        set.add(TpmSaveTypeEnum.ONLY_UPDATE.getCode());
        return set;
    }
    /**
     * 获取提交审批,状态改为审批中的类型集合
     * @return
     */
    public static Set<String> getApprovingTypes(){
        Set<String> set=new HashSet<String>();
        set.add(TpmSaveTypeEnum.NEW_APPROVE.getCode());
        set.add(TpmSaveTypeEnum.UPDATE_APPROVE.getCode());
        set.add(TpmSaveTypeEnum.ONLY_APPROVE.getCode());
        return set;
    }
}
