package com.biz.crm.exception.mdm;

import com.biz.crm.exception.CrmExceptionType;

/**
 * 价格维护枚举类
 * @author zeyi
 */
public enum MdmPriceSettingException implements CrmExceptionType {

    PRICE_SETTING_NULL("mdm_30001","价格维护数据不能为空"),
    PRICE_SETTING_CODE_EXIST("mdm_30002","价格维护编码已存在"),
    ;

    private String code;
    private String description;

    MdmPriceSettingException(String code, String description) {
        this.code = code;
        this.description = description;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDescription() {
        return description;
    }
}
