package com.biz.crm.util;


import lombok.Getter;

/**
 * 分页工具
 *  @author: luoqi
 *  @Date: 2021-1-30 16:58
 *  @version: V1.0
 *  @Description:
 */
public class PageDataAdviser {

    private Integer pageNum = 0;
    @Getter
    private Integer pageSize;

    public PageDataAdviser(int pageSize){
        this.pageSize = pageSize;
    }

    /**
     * 是否还有下一页
     * @return
     */
    public boolean hasNext(Long total){
        if(null == total){
            return false;
        }
        long pageNumTemp = total / this.pageSize;
        if(pageNumTemp > this.pageNum){
            return true;
        }

        if (pageNumTemp == this.pageNum && total % this.pageSize > 0) {
            return true;
        }
        return false;
    }

    /**
     * 获取下一页页码
     * @return
     */
    public Integer nextPage(){
        this.pageNum ++;
        return this.pageNum;
    }
}
