package com.biz.crm.config;

import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import javax.servlet.http.HttpServletRequest;
import java.util.Objects;

/**
 * @Project crm
 * @PackageName PACKAGE_NAME
 * @ClassName com.biz.crm.config.ResultResponseBodyHandler
 * @Author HuangLong
 * @Date 2021/1/14 12:26
 * @Description TODO
 */
//@ControllerAdvice
@Slf4j
public class ResultResponseBodyHandler implements ResponseBodyAdvice<Object> {
    @Override
    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        ServletRequestAttributes httpRequest = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest servletRequest = httpRequest.getRequest();
        Object flag = servletRequest.getAttribute(CommonConstant.RESULT_RESPONSE_FLAG);
        //如果标识不为空,返回true,会执行下面的beforeBodyWrite方法
        if(Objects.nonNull(flag)){
            return true;
        }
        return false;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if(body instanceof Result){
            return body;
        }
        //将返回结果包装成Result
        return Result.ok(body);
    }
}
