package com.biz.crm.eunm.mdm;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 权限数据来源
 *
 * @author zxw
 * @date 2021-01-07 11:36
 **/
@AllArgsConstructor
@Getter
public enum PermissionResourceEnum {

    /**
     * 权限数据来源
     */
    PRESUPPOSITION("0", "预设值"),
    FIXED("1", "固定值"),
    DEFAULT("-1", "默认"),
    ;

    private final String code;

    private final String desc;

    public static boolean contain(String code) {
        if(code==null||"".equals(code.trim())){
            return false;
        }
        PermissionResourceEnum[] values = PermissionResourceEnum.values();
        for (PermissionResourceEnum value : values) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }

    public static PermissionResourceEnum convertEnum(String code) {
        if (code == null || "".equals(code.trim())) {
            return DEFAULT;
        }
        PermissionResourceEnum[] values = PermissionResourceEnum.values();
        for (PermissionResourceEnum value : values) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return DEFAULT;
    }
}
