package com.biz.crm.eunm.tpm;

import org.apache.commons.lang3.StringUtils;

/**
 * @Description:  上账数据的提交状态
 * @Author:: weikangning
 * @Date: 2020/10/13 11:07
 */
public enum AccountStatusEnum {
  TEMP("temp","暂存"),
  SUBMIT("submit","已提交"),
  ;

  private String code;
  private String des;

  AccountStatusEnum(String code, String des) {
    this.code = code;
    this.des = des;
  }

  public String getCode() {
    return code;
  }
  public String getDes() {
    return des;
  }


  public static String getStatusName(String code){
    ActApproveStatusEnum[] values = ActApproveStatusEnum.values();
    String desc=null;
    for (ActApproveStatusEnum o : values){
      if(StringUtils.equals(o.getCode(),code)){
        desc=o.getDes();
        break;
      }
    }
    return desc;
  }
}
