package com.biz.crm.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.codec.Hex;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

/**
 * 加密
 *
 * @author zxw
 * @date 2020-10-22 21:40
 **/
public class AesEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(AesEncoder.class);
    /**
     * 加密密码
     */
    private String secret = "abcdefgh12345678";
    /**
     * 加密方式为CBC
     */
    private final String encodeType = "AES/CBC/PKCS5Padding";

    /**
     * 输出是否采用base64
     */
    private boolean encodeHashAsBase64;

    public AesEncoder() {

    }

    public static void main(String[] args) {
        String encode = new AesEncoder().encode("123456");
        System.out.println("encode = " + encode);
    }

    /**
     * 有自定义密码的加密
     * @param secret 必须为16位密码
     */
    public AesEncoder(String secret) {
        this.secret = secret;
    }

    public String encode(CharSequence rawPassword) {
        Validate.notBlank(rawPassword, "密码不能为空");
        byte[] bytes = rawPassword.toString().getBytes(StandardCharsets.UTF_8);
        byte[] key = secret.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        IvParameterSpec iv = new IvParameterSpec(key);
        try {
            Cipher cipher = Cipher.getInstance(encodeType);
            cipher.init(Cipher.ENCRYPT_MODE, keySpec, iv);
            byte[] enBytes = cipher.doFinal(bytes);
            return this.encode(enBytes);
        } catch (NoSuchAlgorithmException | InvalidKeyException | InvalidAlgorithmParameterException
                | NoSuchPaddingException | BadPaddingException | IllegalBlockSizeException e) {
            LOGGER.error(e.getMessage(), e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    /**
     * 对byte数据进行base64或Hex编码输出
     * @param bytes
     * @return
     */
    private String encode(byte[] bytes) {
        if(encodeHashAsBase64) {
            return Base64.getEncoder().encodeToString(bytes);
        }
        return String.valueOf(Hex.encode(bytes));
    }

    /**
     * 解析base64编码和Hex编码
     * @param encodedPassword
     * @return
     */
    private byte[] decodeHB(String encodedPassword) {
        if(encodeHashAsBase64) {
            return Base64.getDecoder().decode(encodedPassword);
        }
        return Hex.decode(encodedPassword);
    }

    public boolean matches(CharSequence rawPassword, String encodedPassword) {
        if(org.apache.commons.lang3.StringUtils.isBlank(rawPassword) || StringUtils.isBlank(encodedPassword)) {
            return false;
        }
        String encode = encode(rawPassword);
        return encode.equals(encodedPassword);
    }

    /**
     * 加密字符解密成明文
     * @param encodedPassword
     * @return
     */
    public String decode(String encodedPassword) {
        Validate.notBlank(encodedPassword, "密码不能为空");
        byte[] encodedBytes = this.decodeHB(encodedPassword);
        byte[] key = secret.getBytes(StandardCharsets.UTF_8);
        SecretKeySpec keySpec = new SecretKeySpec(key, "AES");
        try {
            Cipher cipher = Cipher.getInstance(encodeType);
            IvParameterSpec iv = new IvParameterSpec(key);
            cipher.init(Cipher.DECRYPT_MODE, keySpec, iv);
            byte[] bytes = cipher.doFinal(encodedBytes);
            return new String(bytes, StandardCharsets.UTF_8);
        } catch (NoSuchAlgorithmException |InvalidKeyException| InvalidAlgorithmParameterException | NoSuchPaddingException
                | BadPaddingException | IllegalBlockSizeException e) {
            LOGGER.error(e.getMessage(), e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    /**
     * 设置hash编码是否是base64
     * @param encodeHashAsBase64
     */
    public void setEncodeHashAsBase64(boolean encodeHashAsBase64) {
        this.encodeHashAsBase64 = encodeHashAsBase64;
    }
}
