package com.biz.crm.util;

import com.biz.crm.eunm.LanguageTypeEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * @Project crm
 * @PackageName com.biz.crm.util
 * @ClassName MsgTransferUtil
 * @Author HuangLong
 * @Date 2020/9/2 14:48
 * @Description 异常信息多语种转换工具类
 */
public class MsgTranslateUtil {

    /**
     * 翻译成对应的语言
     * @param exceptionCode
     * @param desc
     * @param languageType
     * @return
     */
    public static String convert(String exceptionCode, String desc, LanguageTypeEnum languageType){
        //中文
        if(StringUtils.equals(LanguageTypeEnum.CHINA.getCode(),languageType.getCode())){
            return new StringBuffer().append(exceptionCode).append(":").append(desc).toString();
        }else {
            return "";
        }
    }
}
