package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/9/3 17:37
 **/
public class ValidateUtils {


  /**
   * 验证方法
   * @param obj
   * @param errMsg
   */
  public static void validate(Object obj, String errMsg) {
    if (obj == null || obj.toString().equals("")) {
      throw new BusinessException(errMsg);
    }
  }

  /**
   * 验证方法(支持报错信息插入业务数据)
   * @param obj
   * @param errMsg
   */
  public static void validate(Object obj, String errMsg, Object... format) {
    if (obj == null || obj.toString().equals("")) {
      throw new BusinessException(String.format(errMsg, format));
    }
  }

  /**
   * 验证集合为空
   * @param collection
   * @param errMsg
   */
  public static void isEmpty(Collection collection, String errMsg, String... format) {
    if (collection != null && collection.size() > 0) {
      throw new BusinessException(String.format(errMsg, format));
    }
  }

  /**
   * 验证集合不为空
   * @param collection
   * @param errMsg
   */
  public static void notEmpty(Collection collection, String errMsg, String... format) {
    if (collection ==null || collection.size() == 0) {
      throw new BusinessException(String.format(errMsg, format));
    }
  }

  /**
   * 验证MAP不为空
   * @param map
   * @param errMsg
   */
  public static void notEmpty(Map map, String errMsg, String... format) {
    if (map ==null || map.size() == 0) {
      throw new BusinessException(String.format(errMsg, format));
    }
  }

  /**
   * 校验是否正确
   * @param bol
   * @param errMsg
   */
  public static void isTrue(boolean bol, String errMsg, Object... format) {
    if(format != null){
      errMsg = String.format(errMsg, format);
    }
    if(!bol) {
      throw new BusinessException(errMsg);
    }
  }
}
