/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.mdm.ApprovalType;
import com.biz.crm.eunm.mdm.MdmApprovalConfig;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.mdm.approval.MdmApprovalConfigFeign;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigConditionRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigRedisVo;
import com.biz.crm.nebular.mdm.approval.resp.MdmApprovalConfigVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.ReflectUtil;
import com.biz.crm.util.Result;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ApprovalConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(ApprovalConfigUtil.class);
    private static RedisService redisService;
    private static MdmApprovalConfigFeign mdmApprovalConfigFeign;

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    @Autowired
    public void setMdmApprovalConfigFeign(MdmApprovalConfigFeign approvalConfigFeign) {
        mdmApprovalConfigFeign = approvalConfigFeign;
    }

    public static MdmApprovalConfigVo getConfig(String businessCode) {
        return ApprovalConfigUtil.getConfig(businessCode, false);
    }

    public static MdmApprovalConfigVo getConfig(String businessCode, boolean notNull) {
        Assert.hasText((String)businessCode, (String)"\u7f3a\u5931\u4e1a\u52a1\u7f16\u7801");
        if (!StringUtils.isEmpty((CharSequence)businessCode)) {
            MdmApprovalConfigRedisVo redisVo = ApprovalConfigUtil.get(businessCode);
            if (notNull) {
                Assert.notNull((Object)redisVo, (String)"\u672a\u627e\u5230\u914d\u7f6e");
            }
            return CrmBeanUtil.copy(redisVo, MdmApprovalConfigVo.class);
        }
        return null;
    }

    public static ApprovalType checkAndGet(String businessCode, Object paramObj) {
        List collect;
        MdmApprovalConfigRedisVo redisVo = ApprovalConfigUtil.get(businessCode);
        if (redisVo == null) {
            return ApprovalType.NULL;
        }
        if (YesNoEnum.yesNoEnum.ZERO.getValue().equals(redisVo.getControlFlag())) {
            return ApprovalType.NULL;
        }
        Assert.hasText((String)redisVo.getApprovalType(), (String)("\u5ba1\u6279\u914d\u7f6e\u3010" + redisVo.getBusinessName() + "\u3011\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5931\u5ba1\u6279\u7c7b\u578b"));
        Assert.hasText((String)redisVo.getControlScope(), (String)("\u5ba1\u6279\u914d\u7f6e\u3010" + redisVo.getBusinessName() + "\u3011\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5931\u63a7\u5236\u8303\u56f4"));
        if (MdmApprovalConfig.ControlScope.ALL.getValue().equals(redisVo.getControlScope())) {
            return ApprovalType.getEnum((String)redisVo.getApprovalType());
        }
        Assert.hasText((String)redisVo.getConditionLogicalType(), (String)("\u5ba1\u6279\u914d\u7f6e\u3010" + redisVo.getBusinessName() + "\u3011\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5931\u6761\u4ef6\u8fd0\u7b97\u65b9\u5f0f"));
        List conditionList = redisVo.getConditionList();
        Assert.notEmpty((Collection)conditionList, (String)("\u5ba1\u6279\u914d\u7f6e\u3010" + redisVo.getBusinessName() + "\u3011\u4e0d\u5b8c\u6574\uff0c\u7f3a\u5931\u5ba1\u6279\u6761\u4ef6"));
        HashMap<String, Boolean> conditionResultMap = new HashMap<String, Boolean>(16);
        for (MdmApprovalConfigConditionRedisVo condition : conditionList) {
            if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(condition.getControlFlag())) continue;
            String fieldCode = condition.getFieldCode();
            if (!ReflectUtil.checkFieldExist(paramObj, fieldCode)) {
                throw new BusinessException("\u53c2\u6570\u672a\u627e\u5230\u5b57\u6bb5" + condition.getFieldName() + "[" + condition.getFieldCode() + "]");
            }
            Object filedValueObj = ReflectUtil.getFiledValueByName(paramObj, fieldCode);
            boolean b = ApprovalConfigUtil.checkCondition(filedValueObj == null ? "" : filedValueObj.toString(), condition);
            if (MdmApprovalConfig.ConditionLogicalType.OR.getValue().equals(redisVo.getConditionLogicalType()) && b) {
                return ApprovalType.getEnum((String)redisVo.getApprovalType());
            }
            if (MdmApprovalConfig.ConditionLogicalType.AND.getValue().equals(redisVo.getConditionLogicalType()) && !b) {
                return ApprovalType.NULL;
            }
            conditionResultMap.put(condition.getFieldCode(), b);
        }
        if (conditionResultMap.isEmpty()) {
            return ApprovalType.NULL;
        }
        if (MdmApprovalConfig.ConditionLogicalType.OR.getValue().equals(redisVo.getConditionLogicalType())) {
            collect = conditionResultMap.values().stream().filter(x -> x).collect(Collectors.toList());
            if (!collect.isEmpty()) {
                return ApprovalType.getEnum((String)redisVo.getApprovalType());
            }
        } else if (MdmApprovalConfig.ConditionLogicalType.AND.getValue().equals(redisVo.getConditionLogicalType())) {
            collect = conditionResultMap.values().stream().filter(x -> x == false).collect(Collectors.toList());
            if (collect.isEmpty()) {
                return ApprovalType.getEnum((String)redisVo.getApprovalType());
            }
            return ApprovalType.NULL;
        }
        return ApprovalType.NULL;
    }

    public static boolean editableCheck(String approvalType, String approvalStatus) {
        return approvalType == null || "".equals(approvalType) || approvalStatus == null || "".equals(approvalStatus) || !ApprovalType.BPM.getValue().equals(approvalType) && !ApprovalType.STATUS.getValue().equals(approvalType) || !MdmBpmStatusEnum.PASS.getValue().equals(approvalStatus) && !MdmBpmStatusEnum.APPROVAL.getValue().equals(approvalStatus);
    }

    public static void deleteCache(String businessCode) {
        if (StringUtils.isNotEmpty((CharSequence)businessCode)) {
            redisService.del(new String[]{"MDM_APPROVAL_CONFIG_0327:" + businessCode});
            redisService.del(new String[]{"MDM_APPROVAL_CONFIG_LOCK_0327:" + businessCode});
        }
    }

    public static void deleteCache(List<String> businessCodeList) {
        if (businessCodeList != null && businessCodeList.size() > 0) {
            redisService.del((String[])businessCodeList.stream().map(x -> "MDM_APPROVAL_CONFIG_0327:" + x).toArray(String[]::new));
            redisService.del((String[])businessCodeList.stream().map(x -> "MDM_APPROVAL_CONFIG_LOCK_0327:" + x).toArray(String[]::new));
        }
    }

    private static boolean checkCondition(String fieldValue, MdmApprovalConfigConditionRedisVo condition) {
        String[] split;
        if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(condition.getControlFlag())) {
            return true;
        }
        String fieldKeywords = condition.getFieldKeywords();
        if (StringUtils.isEmpty((CharSequence)fieldKeywords)) {
            throw new BusinessException("\u6761\u4ef6" + condition.getFieldName() + "\u7f3a\u5931\u5173\u952e\u503c");
        }
        for (String keywords : split = fieldKeywords.split(",")) {
            if (!MdmApprovalConfig.FieldCompareType.EQ.getValue().equals(condition.getCompareType()) || !fieldValue.equals(keywords)) continue;
            return true;
        }
        return false;
    }

    private static MdmApprovalConfigRedisVo get(String businessCode) {
        MdmApprovalConfigRedisVo redisVo = null;
        if (!ApprovalConfigUtil.checkLock(businessCode)) {
            String key = "MDM_APPROVAL_CONFIG_0327:" + businessCode;
            Object o = redisService.get(key);
            if (o == null) {
                Result result = mdmApprovalConfigFeign.queryForRedis(businessCode);
                Assert.isTrue((boolean)result.isSuccess(), (String)"\u83b7\u53d6\u5ba1\u6279\u914d\u7f6e\u5931\u8d25");
                if (result.getResult() == null) {
                    ApprovalConfigUtil.lock(businessCode);
                } else {
                    redisVo = (MdmApprovalConfigRedisVo)result.getResult();
                    redisService.setSeconds(key, (Object)redisVo, 2592000L);
                }
            } else {
                redisVo = (MdmApprovalConfigRedisVo)o;
            }
        }
        return redisVo;
    }

    private static void lock(String businessCode) {
        redisService.set("MDM_APPROVAL_CONFIG_LOCK_0327:" + businessCode, (Object)2592000);
    }

    private static boolean checkLock(String businessCode) {
        Object o = redisService.get("MDM_APPROVAL_CONFIG_LOCK_0327:" + businessCode);
        return o != null;
    }
}

