/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import java.time.LocalDate;
import java.time.LocalTime;
import org.springframework.util.StringUtils;

public class AssertDateTimeUtils {
    public static void checkTime(String time, String msg) {
        try {
            LocalTime.parse(time);
        }
        catch (Exception e) {
            throw new BusinessException(msg);
        }
    }

    public static void notAfterTime(String beginTime, String endTime, String msg) {
        if (LocalTime.parse(beginTime).isAfter(LocalTime.parse(endTime))) {
            throw new BusinessException(msg);
        }
    }

    public static void notAfterDate(String beginTime, String endTime, String msg) {
        if (LocalDate.parse(beginTime).isAfter(LocalDate.parse(endTime))) {
            throw new BusinessException(msg);
        }
    }

    public static void checkTimeMore(String msg, String ... times) {
        for (String time : times) {
            AssertDateTimeUtils.checkTime(time, msg);
        }
    }

    public static void checkDate(String date, String msg) {
        try {
            LocalDate.parse(date);
        }
        catch (Exception e) {
            throw new BusinessException(msg);
        }
    }

    public static void checkDateAndNull(String date, String nullMsg, String msg) {
        if (StringUtils.isEmpty((Object)date)) {
            throw new BusinessException(nullMsg);
        }
        AssertDateTimeUtils.checkDate(date, msg);
    }

    public static void checkBetweenTime(String nowTime, String beginTime, String endTime, String msg) {
        LocalTime timeNow = LocalTime.parse(nowTime);
        LocalTime timeBegin = LocalTime.parse(beginTime);
        LocalTime timeEnd = LocalTime.parse(endTime);
        if (timeBegin.compareTo(timeNow) > 0 || timeEnd.compareTo(timeNow) < 0) {
            throw new BusinessException(msg);
        }
    }
}

