/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.mdm.bpmrole.MdmBpmRoleRedisFeign;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRedisRespVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BpmRoleUtil {
    private static final Logger log = LoggerFactory.getLogger(BpmRoleUtil.class);
    private static RedisService redisService;
    private static MdmBpmRoleRedisFeign mdmbpmRoleRedisFeign;

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    @Autowired
    public void setMdmBpmRoleRedisFeign(MdmBpmRoleRedisFeign bpmRoleRedisFeign) {
        mdmbpmRoleRedisFeign = bpmRoleRedisFeign;
    }

    public static MdmBpmRoleRespVo getBpmRoleCode(String code) {
        Map<String, MdmBpmRoleRedisRespVo> bpmRoleRedisMap;
        if (code != null && !"".equals(code) && (bpmRoleRedisMap = BpmRoleUtil.getBpmRoleSelfRedisMapFromRedisFirst(Collections.singletonList(code))).containsKey(code)) {
            MdmBpmRoleRedisRespVo mdmBpmRoleRedisRespVo = bpmRoleRedisMap.get(code);
            return CrmBeanUtil.copy(mdmBpmRoleRedisRespVo, MdmBpmRoleRespVo.class);
        }
        return null;
    }

    public static List<MdmBpmRoleRespVo> getBpmRoleCodeList(List<String> codeList) {
        Map<String, MdmBpmRoleRedisRespVo> bpmRoleRedisMap;
        ArrayList<MdmBpmRoleRespVo> list = new ArrayList<MdmBpmRoleRespVo>();
        if (codeList != null && codeList.size() > 0 && !(bpmRoleRedisMap = BpmRoleUtil.getBpmRoleSelfRedisMapFromRedisFirst(codeList)).isEmpty()) {
            list.addAll(bpmRoleRedisMap.values().stream().map(item -> CrmBeanUtil.copy(item, MdmBpmRoleRespVo.class)).collect(Collectors.toList()));
        }
        return list;
    }

    private static Map<String, MdmBpmRoleRedisRespVo> getBpmRoleSelfRedisMapFromRedisFirst(List<String> bpmRoleCodeList) {
        HashMap<String, MdmBpmRoleRedisRespVo> map = new HashMap<String, MdmBpmRoleRedisRespVo>(16);
        try {
            if (bpmRoleCodeList != null && bpmRoleCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List bpmRoleListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_BPM_ROLE_LOCK_HASH_0112:", new HashSet<String>(bpmRoleCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = bpmRoleCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (bpmRoleListFromRedis = redisService.hmget("MDM_BPM_ROLE_SELF_HASH_0112:", new HashSet(notLockGetFromRedisCodeSet))) != null && bpmRoleListFromRedis.size() > 0 && (collect = bpmRoleListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmBpmRoleRedisRespVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmBpmRoleRedisRespVo::getBpmRoleCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmbpmRoleRedisFeign.findRedisListByBpmRoleCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmBpmRoleRedisRespVo> collect2 = list.stream().collect(Collectors.toMap(MdmBpmRoleRedisRespVo::getBpmRoleCode, v -> v));
                        HashMap<String, MdmBpmRoleRedisRespVo> cacheMap = new HashMap<String, MdmBpmRoleRedisRespVo>(16);
                        for (String bpmRoleCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(bpmRoleCode)) {
                                lockCodeMap.put(bpmRoleCode, bpmRoleCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(bpmRoleCode));
                            cacheMap.put(bpmRoleCode, collect2.get(bpmRoleCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_BPM_ROLE_SELF_HASH_0112:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_BPM_ROLE_LOCK_HASH_0112:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmBpmRoleRedisRespVo::getBpmRoleCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u7ec4\u7ec7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    public static void deleteByBpmRoleCode(List<String> code) {
        if (code != null && code.size() > 0) {
            redisService.hdel("MDM_BPM_ROLE_SELF_HASH_0112:", code.toArray());
        }
    }

    public static void deleteAllCache() {
        redisService.del(new String[]{"MDM_BPM_ROLE_LOCK_HASH_0112:"});
        redisService.del(new String[]{"MDM_BPM_ROLE_SELF_HASH_0112:"});
    }

    public static void reloadAllCache() {
        List list;
        BpmRoleUtil.deleteAllCache();
        Result result = mdmbpmRoleRedisFeign.findRedisReloadList();
        if (result.isSuccess() && (list = (List)result.getResult()) != null && list.size() > 0) {
            List partition = Lists.partition((List)list, (int)500);
            for (List item : partition) {
                Map<String, MdmBpmRoleRedisRespVo> map = item.stream().collect(Collectors.toMap(MdmBpmRoleRedisRespVo::getBpmRoleCode, v -> v));
                redisService.hmset("MDM_BPM_ROLE_SELF_HASH_0112:", new HashMap<String, MdmBpmRoleRedisRespVo>(map));
            }
        }
    }
}

