/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util.es.permission;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentUserPermissionRespVo;
import com.biz.crm.util.JsonPropertyUtil;
import com.biz.crm.util.PermissionUtil;
import com.biz.crm.util.es.permission.EsDataPermissionContext;
import com.biz.crm.util.es.permission.EsDataPermissionResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Aspect
@Component
public class EsDataPermissionSupportAspect {
    private static final Logger log = LoggerFactory.getLogger(EsDataPermissionSupportAspect.class);
    private static final String DEF_VAL = "-10000";

    @Before(value="execution(* org.springframework.data.elasticsearch.core.ElasticsearchOperations.*Page(..))")
    public void doBefore(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        if (null == args || args.length == 0) {
            return;
        }
        Object query = args[0];
        if (null == query) {
            return;
        }
        EsDataPermissionResolver permission = (EsDataPermissionResolver)ThreadLocalUtil.getObj((String)"ES_DATA_PERMISSION_KEY");
        if (null == permission) {
            if (log.isInfoEnabled()) {
                log.info("ES\u6570\u636e\u6743\u9650\u5207\u9762\u62e6\u622a\uff1a\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7ebf\u7a0b\u6743\u9650\u6ce8\u89e3\u526f\u672c\uff01");
            }
            return;
        }
        MdmCurrentPermissionRespVo permissionRespVo = this.loadPermissionConfig();
        if (null == permissionRespVo) {
            return;
        }
        if (query instanceof SearchQuery) {
            EsDataPermissionContext<SearchQuery> context = new EsDataPermissionContext<SearchQuery>();
            context.setPermission(permission);
            context.setFilterPermissionObjCodeList(permissionRespVo.getFilterPermissionObjCodeList());
            context.setUserPermissionList(permissionRespVo.getUserPermissionList());
            context.setQuery((SearchQuery)query);
            this.forSearchQuery(context);
        }
    }

    protected MdmCurrentPermissionRespVo loadPermissionConfig() {
        MdmCurrentPermissionRespVo permissionRespVo = PermissionUtil.currentUserPermissionList();
        if (null == permissionRespVo) {
            if (log.isInfoEnabled()) {
                log.info("ES\u6570\u636e\u6743\u9650\u5207\u9762\u62e6\u622a\uff1a\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u6743\u9650\u914d\u7f6e\u6570\u636e\uff01");
            }
            return null;
        }
        List filterPermissionObjCodeList = permissionRespVo.getFilterPermissionObjCodeList();
        if (CollectionUtils.isEmpty((Collection)filterPermissionObjCodeList)) {
            if (log.isInfoEnabled()) {
                log.info("ES\u6570\u636e\u6743\u9650\u5207\u9762\u62e6\u622a\uff1a\u672a\u83b7\u53d6\u5230\u5f53\u524d\u63a5\u53e3\u6743\u9650\u5bf9\u8c61\u914d\u7f6e\u6570\u636e\uff01");
            }
            return null;
        }
        List userPermissionList = permissionRespVo.getUserPermissionList();
        if (null == userPermissionList) {
            if (log.isInfoEnabled()) {
                log.info("ES\u6570\u636e\u6743\u9650\u5207\u9762\u62e6\u622a\uff1a\u672a\u83b7\u53d6\u5230\u5f53\u524d\u63a5\u53e3\u6743\u9650\u503c\u6570\u636e\uff01");
            }
            permissionRespVo.setUserPermissionList((List)Lists.newArrayList());
        }
        return permissionRespVo;
    }

    protected void forSearchQuery(EsDataPermissionContext<SearchQuery> context) {
        if (log.isInfoEnabled()) {
            log.info("ES\u6570\u636e\u6743\u9650\u5207\u9762\u62e6\u622a\uff1acontext = {}", (Object)JsonPropertyUtil.toJsonString(context));
        }
        SearchQuery query = context.getQuery();
        EsDataPermissionResolver permission = context.getPermission();
        List<String> filterPermissionObjCodeList = context.getFilterPermissionObjCodeList();
        List<MdmCurrentUserPermissionRespVo> userPermissionList = context.getUserPermissionList();
        Map<String, List<MdmCurrentUserPermissionRespVo>> groupByObjCode = userPermissionList.stream().collect(Collectors.groupingBy(MdmCurrentUserPermissionRespVo::getPermissionObjCode));
        BoolQueryBuilder boolQueryBuilder = (BoolQueryBuilder)query.getQuery();
        for (String objCode : filterPermissionObjCodeList) {
            if (!groupByObjCode.containsKey(objCode)) continue;
            List<String> permissionValues = this.permissionValues(groupByObjCode.get(objCode));
            String dataFieldName = (String)permission.get(objCode);
            if (StringUtils.isBlank((CharSequence)dataFieldName)) continue;
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)dataFieldName, permissionValues));
        }
    }

    protected List<String> permissionValues(List<MdmCurrentUserPermissionRespVo> permissionRespVos) {
        if (null == permissionRespVos) {
            permissionRespVos = Lists.newArrayList();
        }
        ArrayList permissionValues = Lists.newArrayList();
        for (MdmCurrentUserPermissionRespVo permissionRespVo : permissionRespVos) {
            if (null == permissionRespVo.getPermissionValueList()) continue;
            permissionValues.addAll(permissionRespVo.getPermissionValueList());
        }
        if (permissionValues.size() == 0) {
            permissionValues.add(DEF_VAL);
        }
        return permissionValues;
    }
}

