/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.DictItemVo;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.util.DictUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.common.util.set.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(BaseServiceHelper.class);

    public void setPublicParamsNull(CrmBaseEntity entity) {
        entity.setId(null);
        entity.setCreateCode(null);
        entity.setCreateDate(null);
        entity.setCreateDateSecond(null);
        entity.setCreateName(null);
        entity.setCreateOrgCode(null);
        entity.setCreatePosCode(null);
        entity.setCreateOrgName(null);
        entity.setCreatePosName(null);
        entity.setCreateDateAll(null);
        entity.setUpdateDateAll(null);
        entity.setUpdateCode(null);
        entity.setUpdateDate(null);
        entity.setUpdateDateSecond(null);
        entity.setUpdateName(null);
        entity.setUpdateOrgCode(null);
        entity.setUpdatePosCode(null);
        entity.setUpdateOrgName(null);
        entity.setUpdatePosName(null);
    }

    public void setPublicParamsNull(CrmBaseVo entity) {
        entity.setId(null);
        entity.setCreateCode(null);
        entity.setCreateDate(null);
        entity.setCreateDateSecond(null);
        entity.setCreateName(null);
        entity.setCreateOrgCode(null);
        entity.setCreatePosCode(null);
        entity.setCreateOrgName(null);
        entity.setCreatePosName(null);
        entity.setCreateDateAll(null);
        entity.setUpdateDateAll(null);
        entity.setUpdateCode(null);
        entity.setUpdateDate(null);
        entity.setUpdateDateSecond(null);
        entity.setUpdateName(null);
        entity.setUpdateOrgCode(null);
        entity.setUpdatePosCode(null);
        entity.setUpdateOrgName(null);
        entity.setUpdatePosName(null);
    }

    public List<DictItemVo> convertDictList(Map<String, String> map, String dictJson) {
        if (MapUtils.isEmpty(map)) {
            map = Maps.newHashMap();
        }
        List codes = null;
        try {
            codes = JSON.parseArray((String)dictJson, String.class);
        }
        catch (Exception e) {
            log.error("\u6570\u7ec4json\u8f6c\u6362\u6570\u7ec4\u5931\u8d25,dictJson={}", (Object)dictJson);
        }
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)codes)) {
            for (String p : codes) {
                String s = (String)map.get(p);
                DictItemVo dictItemVo = new DictItemVo();
                dictItemVo.setDictKey(s);
                dictItemVo.setDictValue(p);
                list.add(dictItemVo);
            }
        }
        return list;
    }

    public void isJsonArray(String jsonString, String errorMsg) {
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            try {
                JSONArray jSONArray = JSON.parseArray((String)jsonString);
            }
            catch (Exception e) {
                throw new BusinessException(errorMsg);
            }
        }
    }

    public Map<String, String> getPayTypeTypeMap(String dictTypeCode, String extendDictCode) {
        List<DictDataVo> dataList = DictUtil.list(dictTypeCode);
        return dataList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, v -> v.getExtendMap().get(extendDictCode) == null ? "" : (String)v.getExtendMap().get(extendDictCode)));
    }

    public Map<String, String> getPayTypesMap() {
        return DictUtil.getDictValueMapsByCodes("pay_type_d");
    }

    public Set<String> dealSelectedCodeList(String selectedCode, Set<String> selectedCodeList) {
        if (selectedCodeList == null) {
            selectedCodeList = Sets.newHashSet((Object[])new String[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)selectedCode)) {
            selectedCodeList.add(selectedCode);
        }
        return selectedCodeList;
    }
}

