/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.CrmFeignException;
import com.biz.crm.config.ExceptionMsg;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.handler.KlockTimeoutException;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.wx.WxMsgUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.ActivitiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Value(value="${spring.application.name:}")
    private String applicationName;
    private static RedisService redisService;
    private static String send_wx_msg;
    private static String APPLICATION_NAME;
    @Value(value="${spring.profiles.active:}")
    private String profilesActive;
    private static String PROFILES_ACTIVE;

    @PostConstruct
    public void init() {
        APPLICATION_NAME = this.applicationName;
        PROFILES_ACTIVE = this.profilesActive;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Result errorHandler(Exception e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis != null) {
            log.error("\u8fdb\u5165\u5168\u5c40\u5f02\u5e38\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f \uff1a " + JSON.toJSONString((Object)userRedis));
        }
        log.error("\u8fdb\u5165\u5168\u5c40\u5f02\u5e38", (Throwable)e);
        ExceptionMsg exceptionMsg = GlobalExceptionHandler.getExceptionToString(e, request.getRequestURL());
        return Result.error((String)("\u64cd\u4f5c\u5931\u8d25,\u9519\u8bef\u7f16\u7801" + exceptionMsg.getCode()));
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    public Result errorHandler(BusinessException e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis != null) {
            log.info("\u8fdb\u5165\u5168\u5c40\u5f02\u5e38\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f \uff1a " + JSON.toJSONString((Object)userRedis));
        }
        log.info("\u8fdb\u5165\u5168\u5c40\u4e1a\u52a1\u5f02\u5e38\u5904\u7406", (Throwable)e);
        return Result.error((String)e.getMsg());
    }

    @ExceptionHandler(value={CrmFeignException.class})
    @ResponseBody
    public Result errorHandler(CrmFeignException e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis != null) {
            log.info("\u8fdb\u5165\u5168\u5c40\u5f02\u5e38\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f \uff1a " + JSON.toJSONString((Object)userRedis));
        }
        log.info("\u8fdb\u5165\u5168\u5c40\u4e1a\u52a1\u5f02\u5e38\u5904\u7406", (Throwable)e);
        return Result.error((String)e.getMsg());
    }

    @ExceptionHandler(value={ActivitiException.class})
    @ResponseBody
    public Result errorHandler(ActivitiException e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis != null) {
            log.error("\u8fdb\u5165\u5168\u5c40\u5f02\u5e38\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f \uff1a " + JSON.toJSONString((Object)userRedis));
        }
        log.error("\u8fdb\u5165\u5168\u5c40\u4e1a\u52a1\u5f02\u5e38\u5904\u7406", (Throwable)e);
        String msg = e.getMessage();
        if (StringUtils.isNotEmpty((String)msg) && msg.contains("TaskListener")) {
            String[] msgs = msg.split("TaskListener: ");
            msg = msgs[msgs.length - 1];
        }
        return Result.error((String)msg);
    }

    @ExceptionHandler(value={IOException.class})
    @ResponseBody
    public Result ioeHandler(IOException e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis != null) {
            log.error("\u8fdb\u5165\u5168\u5c40\u5f02\u5e38\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f \uff1a " + JSON.toJSONString((Object)userRedis));
        }
        log.error("\u8fdb\u5165\u5168\u5c40\u4e1a\u52a1\u5f02\u5e38\u5904\u7406", (Throwable)e);
        return null;
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseBody
    public Result assertHandler(IllegalArgumentException e, HttpServletRequest request, HttpServletResponse response) {
        String message = e.getMessage();
        UserRedis userRedis = UserUtils.getUser();
        if (userRedis != null) {
            log.error("\u8fdb\u5165\u5168\u5c40\u5f02\u5e38\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f \uff1a " + JSON.toJSONString((Object)userRedis));
        }
        log.error("\u8fdb\u5165\u5168\u5c40\u4e1a\u52a1\u5f02\u5e38\u5904\u7406", (Throwable)e);
        return Result.error((String)message);
    }

    @ExceptionHandler(value={KlockTimeoutException.class})
    @ResponseBody
    public Result kLockHandler(KlockTimeoutException e, HttpServletRequest request, HttpServletResponse response) {
        UserRedis userRedis = UserUtils.getUser();
        String message = e.getMessage();
        if (userRedis != null) {
            log.error("\u8fdb\u5165\u5168\u5c40\u5f02\u5e38\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f \uff1a " + JSON.toJSONString((Object)userRedis));
        }
        log.error("\u8fdb\u5165\u5168\u5c40\u4e1a\u52a1\u5f02\u5e38\u5904\u7406", (Throwable)e);
        return Result.error((String)("\u8bf7\u4e0d\u8981\u91cd\u590d\u63d0\u4ea4" + message));
    }

    private static ExceptionMsg getExceptionToString(Throwable e, StringBuffer url) {
        long numCode;
        url = url == null ? new StringBuffer() : url;
        ExceptionMsg vo = new ExceptionMsg();
        if (redisService == null) {
            redisService = (RedisService)SpringApplicationContextUtil.getApplicationContext().getBean(RedisService.class);
        }
        if ((numCode = redisService.incr("ERROE_CODE_", 1L)) == 999999L) {
            redisService.set("ERROE_CODE_", (Object)1);
            numCode = 1L;
        }
        String errorCode = "E" + String.valueOf(numCode);
        vo.setCode(errorCode);
        if (e == null) {
            return vo;
        }
        UserRedis userRedis = UserUtils.getUser();
        StringBuffer userMsg = new StringBuffer();
        userMsg.append("\t\u5f53\u524d\u62a5\u9519\u7cfb\u7edf==>").append(APPLICATION_NAME);
        userMsg.append("\n\t\u5f53\u524dtoken==>").append(UserUtils.getToken());
        userMsg.append("\n\t\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f==>");
        if (userRedis != null) {
            userMsg.append(JSONObject.toJSONString((Object)userRedis));
        } else {
            userMsg.append("\u65e0\u767b\u5f55\u4fe1\u606f");
        }
        userMsg.append("\n\t");
        String msg = userMsg.toString() + "\u8bf7\u6c42url:" + url + "\n\t\u9519\u8bef\u65f6\u95f4\uff08" + DateUtil.dateNowHms() + "\uff09 \n\t";
        String parameter = ThreadLocalUtil.getParameter() + "\n\t";
        msg = msg + parameter;
        StringWriter stringWriter = new StringWriter();
        e.printStackTrace(new PrintWriter(stringWriter));
        msg = msg + stringWriter.toString();
        vo.setMsg(msg);
        redisService.setDays("ERROE_MSG_:" + errorCode, (Object)vo, 3L);
        if (send_wx_msg == null) {
            String v = ParamUtil.getParameterValue("send_wx_msg");
            send_wx_msg = v == null ? "N" : v;
        } else if ("Y".equals(send_wx_msg)) {
            GlobalExceptionHandler.createMsgAndSend(errorCode, vo, url.toString());
        }
        return vo;
    }

    private static void createMsgAndSend(String errorCode, ExceptionMsg vo, String url) {
        try {
            if (StringUtils.isEmpty((String)url)) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<font color=\"red\">" + APPLICATION_NAME + "  (" + PROFILES_ACTIVE + "\u73af\u5883!!)  " + "\u9519\u8bef\u7f16\u7801[" + errorCode + "](http://www.baidu.com/)\u5f02\u5e38\u6d88\u606f\u53cd\u9988\uff0c\u8bf7\u76f8\u5173\u540c\u4e8b\u6ce8\u610f\uff01\uff01</font> \n");
            stringBuffer.append(">\u8bf7\u6c42\u5730\u5740:<font color=\"comment\">" + url + "</font>");
            WxMsgUtil.sendMarkdownMsg(stringBuffer.toString());
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u5fae\u4fe1\u63a8\u9001\u5931\u8d25", (Throwable)e);
        }
    }

    static {
        send_wx_msg = null;
    }
}

