/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.mdm.productlevel.MdmProductLevelRedisFeign;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelReloadRedisVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductLevelUtil {
    private static final Logger log = LoggerFactory.getLogger(ProductLevelUtil.class);
    private static RedisService redisService;
    private static MdmProductLevelRedisFeign mdmProductLevelRedisFeign;

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    @Autowired
    public void setMdmProductLevelRedisFeign(MdmProductLevelRedisFeign productLevelRedisFeign) {
        mdmProductLevelRedisFeign = productLevelRedisFeign;
    }

    public static MdmProductLevelRespVo getProductLevelByCode(String productLevelCode) {
        Map<String, MdmProductLevelRedisVo> productLevelRedisMap;
        if (productLevelCode != null && !"".equals(productLevelCode) && (productLevelRedisMap = ProductLevelUtil.getProductLevelSelfRedisMapFromLocalFirst(Collections.singletonList(productLevelCode))).containsKey(productLevelCode)) {
            MdmProductLevelRedisVo mdmProductLevelRedisVo = productLevelRedisMap.get(productLevelCode);
            return CrmBeanUtil.copy(mdmProductLevelRedisVo, MdmProductLevelRespVo.class);
        }
        return null;
    }

    public static List<MdmProductLevelRespVo> getProductLevelByCodeList(List<String> productLevelCodeList) {
        Map<String, MdmProductLevelRedisVo> productLevelRedisMap;
        ArrayList<MdmProductLevelRespVo> list = new ArrayList<MdmProductLevelRespVo>();
        if (productLevelCodeList != null && productLevelCodeList.size() > 0 && !(productLevelRedisMap = ProductLevelUtil.getProductLevelSelfRedisMapFromLocalFirst(productLevelCodeList)).isEmpty()) {
            list.addAll(productLevelRedisMap.values().stream().map(item -> CrmBeanUtil.copy(item, MdmProductLevelRespVo.class)).collect(Collectors.toList()));
        }
        return list;
    }

    public static List<MdmProductLevelRespVo> getParentProductLevelListIncludeSelf(String productLevelCode) {
        List list;
        MdmProductLevelParentChildrenRedisVo redisVo;
        Map<String, MdmProductLevelParentChildrenRedisVo> map;
        if (productLevelCode != null && !"".equals(productLevelCode) && !(map = ProductLevelUtil.getProductLevelParentRedisMapFromLocalFirst(Collections.singletonList(productLevelCode))).isEmpty() && (redisVo = map.get(productLevelCode)) != null && (list = redisVo.getList()) != null && list.size() > 0) {
            return CrmBeanUtil.copyList(list, MdmProductLevelRespVo.class);
        }
        return new ArrayList<MdmProductLevelRespVo>();
    }

    public static List<MdmProductLevelRespVo> getParentProductLevelListIncludeSelf(List<String> productLevelCodeList) {
        if (productLevelCodeList != null && productLevelCodeList.size() > 0) {
            Map<String, MdmProductLevelParentChildrenRedisVo> map = ProductLevelUtil.getProductLevelParentRedisMapFromLocalFirst(productLevelCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String productLevelCode : productLevelCodeList) {
                    MdmProductLevelParentChildrenRedisVo redisVo;
                    if (!map.containsKey(productLevelCode) || (redisVo = map.get(productLevelCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList());
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmProductLevelRespVo.class);
                }
            }
        }
        return new ArrayList<MdmProductLevelRespVo>();
    }

    public static List<MdmProductLevelRespVo> getParentProductLevelListExcludeSelf(String productLevelCode) {
        List<MdmProductLevelRespVo> parentProductLevelListIncludeSelf;
        if (productLevelCode != null && !"".equals(productLevelCode) && (parentProductLevelListIncludeSelf = ProductLevelUtil.getParentProductLevelListIncludeSelf(productLevelCode)) != null && parentProductLevelListIncludeSelf.size() > 0) {
            return parentProductLevelListIncludeSelf.stream().filter(item -> !productLevelCode.equals(item.getProductLevelCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmProductLevelRespVo>();
    }

    public static List<MdmProductLevelRespVo> getParentProductLevelListExcludeSelf(List<String> productLevelCodeList) {
        if (productLevelCodeList != null && productLevelCodeList.size() > 0) {
            Map<String, MdmProductLevelParentChildrenRedisVo> map = ProductLevelUtil.getProductLevelParentRedisMapFromLocalFirst(productLevelCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String productLevelCode : productLevelCodeList) {
                    MdmProductLevelParentChildrenRedisVo redisVo;
                    if (!map.containsKey(productLevelCode) || (redisVo = map.get(productLevelCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList().stream().filter(item -> !productLevelCode.equals(item.getProductLevelCode())).collect(Collectors.toSet()));
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmProductLevelRespVo.class);
                }
            }
        }
        return new ArrayList<MdmProductLevelRespVo>();
    }

    public static List<MdmProductLevelRespVo> getParentProductLevelListExcludeAnySelf(List<String> productLevelCodeList) {
        List<MdmProductLevelRespVo> parentProductLevelListExcludeSelf;
        if (productLevelCodeList != null && productLevelCodeList.size() > 0 && (parentProductLevelListExcludeSelf = ProductLevelUtil.getParentProductLevelListExcludeSelf(productLevelCodeList)) != null && parentProductLevelListExcludeSelf.size() > 0) {
            HashSet<String> productLevelCodeSet = new HashSet<String>(productLevelCodeList);
            return parentProductLevelListExcludeSelf.stream().filter(item -> !productLevelCodeSet.contains(item.getProductLevelCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmProductLevelRespVo>();
    }

    public static List<MdmProductLevelRespVo> getChildrenProductLevelListIncludeSelf(String productLevelCode) {
        List list;
        MdmProductLevelParentChildrenRedisVo redisVo;
        Map<String, MdmProductLevelParentChildrenRedisVo> map;
        if (productLevelCode != null && !"".equals(productLevelCode) && !(map = ProductLevelUtil.getProductLevelChildrenRedisMapFromLocalFirst(Collections.singletonList(productLevelCode))).isEmpty() && (redisVo = map.get(productLevelCode)) != null && (list = redisVo.getList()) != null && list.size() > 0) {
            return CrmBeanUtil.copyList(list, MdmProductLevelRespVo.class);
        }
        return new ArrayList<MdmProductLevelRespVo>();
    }

    public static List<MdmProductLevelRespVo> getChildrenProductLevelListIncludeSelf(List<String> productLevelCodeList) {
        if (productLevelCodeList != null && productLevelCodeList.size() > 0) {
            Map<String, MdmProductLevelParentChildrenRedisVo> map = ProductLevelUtil.getProductLevelChildrenRedisMapFromLocalFirst(productLevelCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String productLevelCode : productLevelCodeList) {
                    MdmProductLevelParentChildrenRedisVo redisVo;
                    if (!map.containsKey(productLevelCode) || (redisVo = map.get(productLevelCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList());
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmProductLevelRespVo.class);
                }
            }
        }
        return new ArrayList<MdmProductLevelRespVo>();
    }

    public static List<MdmProductLevelRespVo> getChildrenProductLevelListExcludeSelf(String productLevelCode) {
        List<MdmProductLevelRespVo> parentProductLevelListIncludeSelf;
        if (productLevelCode != null && !"".equals(productLevelCode) && (parentProductLevelListIncludeSelf = ProductLevelUtil.getChildrenProductLevelListIncludeSelf(productLevelCode)) != null && parentProductLevelListIncludeSelf.size() > 0) {
            return parentProductLevelListIncludeSelf.stream().filter(item -> !productLevelCode.equals(item.getProductLevelCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmProductLevelRespVo>();
    }

    public static List<MdmProductLevelRespVo> getChildrenProductLevelListExcludeSelf(List<String> productLevelCodeList) {
        if (productLevelCodeList != null && productLevelCodeList.size() > 0) {
            Map<String, MdmProductLevelParentChildrenRedisVo> map = ProductLevelUtil.getProductLevelChildrenRedisMapFromLocalFirst(productLevelCodeList);
            HashSet set = new HashSet(16);
            if (!map.isEmpty()) {
                for (String productLevelCode : productLevelCodeList) {
                    MdmProductLevelParentChildrenRedisVo redisVo;
                    if (!map.containsKey(productLevelCode) || (redisVo = map.get(productLevelCode)) == null || redisVo.getList() == null || redisVo.getList().size() <= 0) continue;
                    set.addAll(redisVo.getList().stream().filter(item -> !productLevelCode.equals(item.getProductLevelCode())).collect(Collectors.toSet()));
                }
                if (!set.isEmpty()) {
                    return CrmBeanUtil.copyList(new ArrayList(set), MdmProductLevelRespVo.class);
                }
            }
        }
        return new ArrayList<MdmProductLevelRespVo>();
    }

    public static List<MdmProductLevelRespVo> getChildrenProductLevelListExcludeAnySelf(List<String> productLevelCodeList) {
        List<MdmProductLevelRespVo> parentProductLevelListExcludeSelf;
        if (productLevelCodeList != null && productLevelCodeList.size() > 0 && (parentProductLevelListExcludeSelf = ProductLevelUtil.getChildrenProductLevelListExcludeSelf(productLevelCodeList)) != null && parentProductLevelListExcludeSelf.size() > 0) {
            HashSet<String> productLevelCodeSet = new HashSet<String>(productLevelCodeList);
            return parentProductLevelListExcludeSelf.stream().filter(item -> !productLevelCodeSet.contains(item.getProductLevelCode())).collect(Collectors.toList());
        }
        return new ArrayList<MdmProductLevelRespVo>();
    }

    public static List<MdmProductLevelRespVo> getParentProductLevelListIncludeSelfEnable(String productLevelCode) {
        return ProductLevelUtil.getParentProductLevelListIncludeSelf(productLevelCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmProductLevelRespVo> getParentProductLevelListIncludeSelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getParentProductLevelListIncludeSelf(productLevelCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmProductLevelRespVo> getParentProductLevelListExcludeSelfEnable(String productLevelCode) {
        return ProductLevelUtil.getParentProductLevelListExcludeSelf(productLevelCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmProductLevelRespVo> getParentProductLevelListExcludeSelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getParentProductLevelListExcludeSelf(productLevelCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmProductLevelRespVo> getParentProductLevelListExcludeAnySelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getParentProductLevelListExcludeAnySelf(productLevelCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmProductLevelRespVo> getChildrenProductLevelListIncludeSelfEnable(String productLevelCode) {
        return ProductLevelUtil.getChildrenProductLevelListIncludeSelf(productLevelCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmProductLevelRespVo> getChildrenProductLevelListIncludeSelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getChildrenProductLevelListIncludeSelf(productLevelCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmProductLevelRespVo> getChildrenProductLevelListExcludeSelfEnable(String productLevelCode) {
        return ProductLevelUtil.getChildrenProductLevelListExcludeSelf(productLevelCode).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmProductLevelRespVo> getChildrenProductLevelListExcludeSelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getChildrenProductLevelListExcludeSelf(productLevelCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<MdmProductLevelRespVo> getChildrenProductLevelListExcludeAnySelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getChildrenProductLevelListExcludeAnySelf(productLevelCodeList).stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus())).collect(Collectors.toList());
    }

    public static List<String> getParentProductLevelCodeListIncludeSelf(String productLevelCode) {
        return ProductLevelUtil.getParentProductLevelListIncludeSelf(productLevelCode).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getParentProductLevelCodeListIncludeSelf(List<String> productLevelCodeList) {
        return ProductLevelUtil.getParentProductLevelListIncludeSelf(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getParentProductLevelCodeListExcludeSelf(String productLevelCode) {
        return ProductLevelUtil.getParentProductLevelListExcludeSelf(productLevelCode).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getParentProductLevelCodeListExcludeSelf(List<String> productLevelCodeList) {
        return ProductLevelUtil.getParentProductLevelListExcludeSelf(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getParentProductLevelCodeListExcludeAnySelf(List<String> productLevelCodeList) {
        return ProductLevelUtil.getParentProductLevelListExcludeAnySelf(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenProductLevelCodeListIncludeSelf(String productLevelCode) {
        return ProductLevelUtil.getChildrenProductLevelListIncludeSelf(productLevelCode).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenProductLevelCodeListIncludeSelf(List<String> productLevelCodeList) {
        return ProductLevelUtil.getChildrenProductLevelListIncludeSelf(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenProductLevelCodeListExcludeSelf(String productLevelCode) {
        return ProductLevelUtil.getChildrenProductLevelListExcludeSelf(productLevelCode).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenProductLevelCodeListExcludeSelf(List<String> productLevelCodeList) {
        return ProductLevelUtil.getChildrenProductLevelListExcludeSelf(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenProductLevelCodeListExcludeAnySelf(List<String> productLevelCodeList) {
        return ProductLevelUtil.getChildrenProductLevelListExcludeAnySelf(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getParentProductLevelCodeListIncludeSelfEnable(String productLevelCode) {
        return ProductLevelUtil.getParentProductLevelListIncludeSelfEnable(productLevelCode).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getParentProductLevelCodeListIncludeSelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getParentProductLevelListIncludeSelfEnable(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getParentProductLevelCodeListExcludeSelfEnable(String productLevelCode) {
        return ProductLevelUtil.getParentProductLevelListExcludeSelfEnable(productLevelCode).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getParentProductLevelCodeListExcludeSelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getParentProductLevelListExcludeSelfEnable(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getParentProductLevelCodeListExcludeAnySelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getParentProductLevelListExcludeAnySelfEnable(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenProductLevelCodeListIncludeSelfEnable(String productLevelCode) {
        return ProductLevelUtil.getChildrenProductLevelListIncludeSelfEnable(productLevelCode).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenProductLevelCodeListIncludeSelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getChildrenProductLevelListIncludeSelfEnable(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenProductLevelCodeListExcludeSelfEnable(String productLevelCode) {
        return ProductLevelUtil.getChildrenProductLevelListExcludeSelfEnable(productLevelCode).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenProductLevelCodeListExcludeSelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getChildrenProductLevelListExcludeSelfEnable(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static List<String> getChildrenProductLevelCodeListExcludeAnySelfEnable(List<String> productLevelCodeList) {
        return ProductLevelUtil.getChildrenProductLevelListExcludeAnySelfEnable(productLevelCodeList).stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList());
    }

    public static void deleteAllCache() {
        redisService.del(new String[]{"MDM_PRODUCT_LEVEL_LOCK_HASH_0112:"});
        redisService.del(new String[]{"MDM_PRODUCT_LEVEL_SELF_HASH_0112:"});
        redisService.del(new String[]{"MDM_PRODUCT_LEVEL_PARENT_HASH_0112:"});
        redisService.del(new String[]{"MDM_PRODUCT_LEVEL_CHILDREN_HASH_0112:"});
        ThreadLocalUtil.delProductLevel();
    }

    public static void reloadAllCache() {
        List list;
        ProductLevelUtil.deleteAllCache();
        Result result = mdmProductLevelRedisFeign.findRedisReloadList();
        if (result.isSuccess() && (list = (List)result.getResult()) != null && list.size() > 0) {
            List partition = Lists.partition((List)list, (int)500);
            for (List item : partition) {
                Map<String, MdmProductLevelRedisVo> selfMap = item.stream().collect(Collectors.toMap(MdmProductLevelReloadRedisVo::getProductLevelCode, MdmProductLevelReloadRedisVo::getSelf));
                Map<String, List> parentMap = item.stream().collect(Collectors.toMap(MdmProductLevelReloadRedisVo::getProductLevelCode, MdmProductLevelReloadRedisVo::getParentList));
                Map<String, List> childrenMap = item.stream().collect(Collectors.toMap(MdmProductLevelReloadRedisVo::getProductLevelCode, MdmProductLevelReloadRedisVo::getChildrenList));
                redisService.hmset("MDM_PRODUCT_LEVEL_SELF_HASH_0112:", new HashMap<String, MdmProductLevelRedisVo>(selfMap));
                redisService.hmset("MDM_PRODUCT_LEVEL_PARENT_HASH_0112:", new HashMap<String, List>(parentMap));
                redisService.hmset("MDM_PRODUCT_LEVEL_CHILDREN_HASH_0112:", new HashMap<String, List>(childrenMap));
            }
        }
    }

    private static Map<String, MdmProductLevelRedisVo> getProductLevelSelfRedisMapFromLocalFirst(List<String> productLevelCodeList) {
        HashMap<String, MdmProductLevelRedisVo> map = new HashMap<String, MdmProductLevelRedisVo>(16);
        try {
            if (productLevelCodeList != null && productLevelCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String productLevelCode : productLevelCodeList) {
                    if (ThreadLocalUtil.productLevelSelfContains((String)productLevelCode)) {
                        MdmProductLevelRedisVo fromProductLevelSelf = ThreadLocalUtil.getFromProductLevelSelf((String)productLevelCode);
                        if (fromProductLevelSelf == null) continue;
                        map.put(productLevelCode, fromProductLevelSelf);
                        continue;
                    }
                    getFromRedisCodeSet.add(productLevelCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmProductLevelRedisVo> mapFromRedisFirst = ProductLevelUtil.getProductLevelSelfRedisMapFromRedisFirst(new ArrayList<String>(productLevelCodeList));
                    for (String productLevelCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(productLevelCode)) {
                            map.put(productLevelCode, mapFromRedisFirst.get(productLevelCode));
                        }
                        ThreadLocalUtil.addToProductLevelSelf((String)productLevelCode, (MdmProductLevelRedisVo)mapFromRedisFirst.get(productLevelCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u4ea7\u54c1\u5c42\u7ea7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmProductLevelRedisVo> getProductLevelSelfRedisMapFromRedisFirst(List<String> productLevelCodeList) {
        HashMap<String, MdmProductLevelRedisVo> map = new HashMap<String, MdmProductLevelRedisVo>(16);
        try {
            if (productLevelCodeList != null && productLevelCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List productLevelListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_PRODUCT_LEVEL_LOCK_HASH_0112:", new HashSet<String>(productLevelCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = productLevelCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (productLevelListFromRedis = redisService.hmget("MDM_PRODUCT_LEVEL_SELF_HASH_0112:", new HashSet(notLockGetFromRedisCodeSet))) != null && productLevelListFromRedis.size() > 0 && (collect = productLevelListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmProductLevelRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmProductLevelRedisVo::getProductLevelCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmProductLevelRedisFeign.findRedisListByProductLevelCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmProductLevelRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmProductLevelRedisVo::getProductLevelCode, v -> v));
                        HashMap<String, MdmProductLevelRedisVo> cacheMap = new HashMap<String, MdmProductLevelRedisVo>(16);
                        for (String productLevelCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(productLevelCode)) {
                                lockCodeMap.put(productLevelCode, productLevelCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(productLevelCode));
                            cacheMap.put(productLevelCode, collect2.get(productLevelCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_PRODUCT_LEVEL_SELF_HASH_0112:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_PRODUCT_LEVEL_LOCK_HASH_0112:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmProductLevelRedisVo::getProductLevelCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u4ea7\u54c1\u5c42\u7ea7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmProductLevelParentChildrenRedisVo> getProductLevelParentRedisMapFromLocalFirst(List<String> productLevelCodeList) {
        HashMap<String, MdmProductLevelParentChildrenRedisVo> map = new HashMap<String, MdmProductLevelParentChildrenRedisVo>(16);
        try {
            if (productLevelCodeList != null && productLevelCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String productLevelCode : productLevelCodeList) {
                    if (ThreadLocalUtil.productLevelParentContains((String)productLevelCode)) {
                        MdmProductLevelParentChildrenRedisVo fromProductLevelParent = ThreadLocalUtil.getFromProductLevelParent((String)productLevelCode);
                        if (fromProductLevelParent == null) continue;
                        map.put(productLevelCode, fromProductLevelParent);
                        continue;
                    }
                    getFromRedisCodeSet.add(productLevelCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmProductLevelParentChildrenRedisVo> mapFromRedisFirst = ProductLevelUtil.getProductLevelParentRedisMapFromRedisFirst(new ArrayList<String>(productLevelCodeList));
                    for (String productLevelCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(productLevelCode)) {
                            map.put(productLevelCode, mapFromRedisFirst.get(productLevelCode));
                        }
                        ThreadLocalUtil.addToProductLevelParent((String)productLevelCode, (MdmProductLevelParentChildrenRedisVo)mapFromRedisFirst.get(productLevelCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u4ea7\u54c1\u5c42\u7ea7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmProductLevelParentChildrenRedisVo> getProductLevelParentRedisMapFromRedisFirst(List<String> productLevelCodeList) {
        HashMap<String, MdmProductLevelParentChildrenRedisVo> map = new HashMap<String, MdmProductLevelParentChildrenRedisVo>(16);
        try {
            if (productLevelCodeList != null && productLevelCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List productLevelListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_PRODUCT_LEVEL_LOCK_HASH_0112:", new HashSet<String>(productLevelCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = productLevelCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (productLevelListFromRedis = redisService.hmget("MDM_PRODUCT_LEVEL_PARENT_HASH_0112:", new HashSet(notLockGetFromRedisCodeSet))) != null && productLevelListFromRedis.size() > 0 && (collect = productLevelListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmProductLevelParentChildrenRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmProductLevelParentChildrenRedisVo::getProductLevelCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmProductLevelRedisFeign.findRedisProductLevelParentListByCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmProductLevelParentChildrenRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmProductLevelParentChildrenRedisVo::getProductLevelCode, v -> v));
                        HashMap<String, MdmProductLevelParentChildrenRedisVo> cacheMap = new HashMap<String, MdmProductLevelParentChildrenRedisVo>(16);
                        for (String productLevelCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(productLevelCode)) {
                                lockCodeMap.put(productLevelCode, productLevelCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(productLevelCode));
                            cacheMap.put(productLevelCode, collect2.get(productLevelCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_PRODUCT_LEVEL_PARENT_HASH_0112:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_PRODUCT_LEVEL_LOCK_HASH_0112:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmProductLevelParentChildrenRedisVo::getProductLevelCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u4ea7\u54c1\u5c42\u7ea7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmProductLevelParentChildrenRedisVo> getProductLevelChildrenRedisMapFromLocalFirst(List<String> productLevelCodeList) {
        HashMap<String, MdmProductLevelParentChildrenRedisVo> map = new HashMap<String, MdmProductLevelParentChildrenRedisVo>(16);
        try {
            if (productLevelCodeList != null && productLevelCodeList.size() > 0) {
                HashSet<String> getFromRedisCodeSet = new HashSet<String>(16);
                for (String productLevelCode : productLevelCodeList) {
                    if (ThreadLocalUtil.productLevelChildrenContains((String)productLevelCode)) {
                        MdmProductLevelParentChildrenRedisVo fromProductLevelChildren = ThreadLocalUtil.getFromProductLevelChildren((String)productLevelCode);
                        if (fromProductLevelChildren == null) continue;
                        map.put(productLevelCode, fromProductLevelChildren);
                        continue;
                    }
                    getFromRedisCodeSet.add(productLevelCode);
                }
                if (!getFromRedisCodeSet.isEmpty()) {
                    Map<String, MdmProductLevelParentChildrenRedisVo> mapFromRedisFirst = ProductLevelUtil.getProductLevelChildrenRedisMapFromRedisFirst(new ArrayList<String>(productLevelCodeList));
                    for (String productLevelCode : getFromRedisCodeSet) {
                        if (mapFromRedisFirst.containsKey(productLevelCode)) {
                            map.put(productLevelCode, mapFromRedisFirst.get(productLevelCode));
                        }
                        ThreadLocalUtil.addToProductLevelChildren((String)productLevelCode, (MdmProductLevelParentChildrenRedisVo)mapFromRedisFirst.get(productLevelCode));
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u4ea7\u54c1\u5c42\u7ea7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }

    private static Map<String, MdmProductLevelParentChildrenRedisVo> getProductLevelChildrenRedisMapFromRedisFirst(List<String> productLevelCodeList) {
        HashMap<String, MdmProductLevelParentChildrenRedisVo> map = new HashMap<String, MdmProductLevelParentChildrenRedisVo>(16);
        try {
            if (productLevelCodeList != null && productLevelCodeList.size() > 0) {
                Result result;
                Set getByFeignCodeSet;
                List collect;
                List productLevelListFromRedis;
                ArrayList<Object> redisVoList = new ArrayList<Object>();
                HashSet lockCodeList = new HashSet(16);
                List lockListFromHash = redisService.hmget("MDM_PRODUCT_LEVEL_LOCK_HASH_0112:", new HashSet<String>(productLevelCodeList));
                if (lockListFromHash != null && lockListFromHash.size() > 0) {
                    lockCodeList.addAll(lockListFromHash.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
                }
                Set notLockGetFromRedisCodeSet = productLevelCodeList.stream().filter(item -> !lockCodeList.contains(item)).collect(Collectors.toSet());
                HashSet redisHasCodeSet = new HashSet(16);
                if (!notLockGetFromRedisCodeSet.isEmpty() && (productLevelListFromRedis = redisService.hmget("MDM_PRODUCT_LEVEL_CHILDREN_HASH_0112:", new HashSet(notLockGetFromRedisCodeSet))) != null && productLevelListFromRedis.size() > 0 && (collect = productLevelListFromRedis.stream().filter(Objects::nonNull).map(item -> CrmBeanUtil.copy(item, MdmProductLevelParentChildrenRedisVo.class)).collect(Collectors.toList())).size() > 0) {
                    redisVoList.addAll(collect);
                    redisHasCodeSet.addAll(collect.stream().map(MdmProductLevelParentChildrenRedisVo::getProductLevelCode).collect(Collectors.toSet()));
                }
                if (!(getByFeignCodeSet = notLockGetFromRedisCodeSet.stream().filter(item -> !redisHasCodeSet.contains(item)).collect(Collectors.toSet())).isEmpty() && (result = mdmProductLevelRedisFeign.findRedisProductLevelChildrenListByCodeList(new ArrayList(getByFeignCodeSet))).isSuccess()) {
                    HashMap<String, String> lockCodeMap = new HashMap<String, String>(16);
                    List list = (List)result.getResult();
                    if (list != null && list.size() > 0) {
                        Map<String, MdmProductLevelParentChildrenRedisVo> collect2 = list.stream().collect(Collectors.toMap(MdmProductLevelParentChildrenRedisVo::getProductLevelCode, v -> v));
                        HashMap<String, MdmProductLevelParentChildrenRedisVo> cacheMap = new HashMap<String, MdmProductLevelParentChildrenRedisVo>(16);
                        for (String productLevelCode : getByFeignCodeSet) {
                            if (!collect2.containsKey(productLevelCode)) {
                                lockCodeMap.put(productLevelCode, productLevelCode);
                                continue;
                            }
                            redisVoList.add(collect2.get(productLevelCode));
                            cacheMap.put(productLevelCode, collect2.get(productLevelCode));
                        }
                        if (!cacheMap.isEmpty()) {
                            redisService.hmset("MDM_PRODUCT_LEVEL_CHILDREN_HASH_0112:", new HashMap(cacheMap));
                        }
                    } else {
                        lockCodeMap.putAll(getByFeignCodeSet.stream().collect(Collectors.toMap(k -> k, v -> v)));
                    }
                    if (!lockCodeMap.isEmpty()) {
                        redisService.hmset("MDM_PRODUCT_LEVEL_LOCK_HASH_0112:", new HashMap(lockCodeMap), 3L);
                    }
                }
                if (redisVoList.size() > 0) {
                    map.putAll(redisVoList.stream().collect(Collectors.toMap(MdmProductLevelParentChildrenRedisVo::getProductLevelCode, v -> v)));
                }
            }
        }
        catch (Exception e) {
            log.error("\u4ea7\u54c1\u5c42\u7ea7\u67e5\u8be2\u5de5\u5177\u7c7b\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return map;
    }
}

