/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAdjusters;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrmDateUtils {
    private static final Logger log = LoggerFactory.getLogger(CrmDateUtils.class);
    public static final DateTimeFormatter yyyyMMddHHmmssSSS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS");
    public static final DateTimeFormatter yyyyMMddHHmmss = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter yyyyMMddHH_mm_ss = DateTimeFormatter.ofPattern("yyyy-MM-dd HH_mm_ss");
    public static final DateTimeFormatter yyyyMMdd = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter HHmmss = DateTimeFormatter.ofPattern("HH:mm:ss");
    public static final DateTimeFormatter yyyyMM = DateTimeFormatter.ofPattern("yyyy-MM");
    public static final DateTimeFormatter yyyy = DateTimeFormatter.ofPattern("yyyy");
    public static final DateTimeFormatter yyyyMMddHHmmss_ = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    public static final DateTimeFormatter yyMMddHHmm = DateTimeFormatter.ofPattern("yyMMddHHmm");
    public static final String TIME_STR_12 = "12:00:00";
    public static final String TIME_STR_00 = "00:00:00";
    public static final String TIME_STR_235959 = "23:59:59";

    private CrmDateUtils() {
    }

    public static LocalDateTime parseyyyyMMddHHmmss(String dateTime) {
        try {
            return LocalDateTime.parse(dateTime, yyyyMMddHHmmss);
        }
        catch (Exception e) {
            throw new BusinessException("\u683c\u5f0f\u5316\u65e5\u671f\u65f6\u95f4\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public static LocalDateTime parseCrmDateTime(String date, String time, boolean maxTime) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        String onEmptyTime = maxTime ? TIME_STR_235959 : TIME_STR_00;
        return CrmDateUtils.parseyyyyMMddHHmmss(date + " " + (StringUtils.isBlank((CharSequence)time) || TIME_STR_00.equals(time) ? onEmptyTime : time));
    }

    public static boolean validFormatYYYY_MM_DD(String date) {
        try {
            LocalDate.parse(date);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isBefore(String firstDate, String secondDate) {
        return LocalDate.parse(firstDate).isBefore(LocalDate.parse(secondDate));
    }

    public static boolean isAfter(String firstDate, String secondDate) {
        return LocalDate.parse(firstDate).isAfter(LocalDate.parse(secondDate));
    }

    public static String gainMonday(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.previous(DayOfWeek.MONDAY)).toString();
    }

    public static String gainSunday(LocalDate localDate) {
        return localDate.plusDays(7L).with(TemporalAdjusters.previous(DayOfWeek.SUNDAY)).toString();
    }

    public static String gainFirstMonth(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.firstDayOfMonth()).toString();
    }

    public static String gainLastMonth(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.lastDayOfMonth()).toString();
    }

    public static boolean checkTimeFormat(String time, DateTimeFormatter formatter) {
        try {
            formatter.parse(time);
            return true;
        }
        catch (DateTimeParseException e) {
            if (log.isInfoEnabled()) {
                log.info("\u65f6\u95f4\u6821\u9a8c\u5931\u8d25", (Throwable)e);
            }
            return false;
        }
    }

    public static void checkTimeFormatThrows(String time, DateTimeFormatter formatter, String msg) throws BusinessException {
        try {
            formatter.parse(time);
        }
        catch (DateTimeParseException e) {
            if (StringUtils.isBlank((CharSequence)msg)) {
                msg = "\u65f6\u95f4\u683c\u5f0f\u9519\u8bef";
            }
            throw new BusinessException(msg, (Throwable)e);
        }
    }
}

