/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.util.ComConstant;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.net.ssl.SSLException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final RequestConfig REQUEST_CONFIG_TIME_OUT = RequestConfig.custom().setSocketTimeout(20000).setConnectTimeout(50000).setConnectionRequestTimeout(50000).build();
    private static PoolingHttpClientConnectionManager cm = null;

    @PostConstruct
    public void init() {
        cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(1000);
        cm.setDefaultMaxPerRoute(1000);
    }

    public static CloseableHttpClient getClient(boolean isPooled) {
        HttpRequestRetryHandler retryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException e, int retryTimes, HttpContext httpContext) {
                boolean idempotent;
                if (retryTimes > 2) {
                    return false;
                }
                if (e instanceof UnknownHostException || e instanceof ConnectTimeoutException || !(e instanceof SSLException) || e instanceof NoHttpResponseException) {
                    return true;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)httpContext);
                HttpRequest request = clientContext.getRequest();
                boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
                return idempotent;
            }
        };
        if (isPooled) {
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler(retryHandler).build();
        }
        return HttpClients.createDefault();
    }

    public static final Result doPostWithRequest(String path, HttpServletRequest request) {
        Result result = new Result();
        Enumeration params = request.getParameterNames();
        ArrayList nameValuePairs = Lists.newArrayList();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            nameValuePairs.add(new BasicNameValuePair(paramName, request.getParameter(paramName)));
        }
        HttpPost httpPost = new HttpPost(path);
        httpPost.setConfig(REQUEST_CONFIG_TIME_OUT);
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity((List)nameValuePairs));
            return HttpClientUtils.execReq(httpPost);
        }
        catch (UnsupportedEncodingException e) {
            log.error("do post error: ", (Throwable)e);
            result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
            result.setMessage(e.getMessage());
            return result;
        }
    }

    public static final Result<String> doGet(String path, Map<String, String> hander) {
        Result<String> result = new Result<String>();
        log.info("doGet from " + path);
        HttpGet httpGet = new HttpGet(path);
        httpGet.setConfig(REQUEST_CONFIG_TIME_OUT);
        try {
            httpGet.setHeader("Content-Type", "application/json; charset=utf-8");
            hander.forEach((k, v) -> httpGet.setHeader(k, v));
            result = HttpClientUtils.execReqGet(httpGet);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Result<String> execReqGet(HttpGet httpGet) {
        Result result = new Result();
        try {
            CloseableHttpResponse response = HttpClientUtils.getClient(true).execute((HttpUriRequest)httpGet);
            if (response == null) {
                result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
                result.setMessage("http get request error: " + httpGet.getURI());
                return result;
            }
            try {
                if (response.getStatusLine().getStatusCode() == 200) {
                    result.setCode(ComConstant.SC_OK_200);
                    result.setResult((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
                    Result result2 = result;
                    return result2;
                }
                result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
                result.setMessage("http get request error: " + httpGet.getURI());
                Result result3 = result;
                return result3;
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (IOException e) {
            log.error("doGet error: ", (Throwable)e);
            result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
            result.setMessage(e.getMessage());
            return result;
        }
    }

    public static final Result<String> doPost(String path, Map<String, Object> params) {
        Result<String> result = new Result<String>();
        log.debug("doPost from " + path, params);
        HttpPost httpPost = new HttpPost(path);
        httpPost.setConfig(REQUEST_CONFIG_TIME_OUT);
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpClientUtils.createParams(params)));
            result = HttpClientUtils.execReq(httpPost);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
            result.setMessage(e.getMessage());
        }
        return result;
    }

    public static final Result<String> doPostWebService(String path, String xml) {
        log.info("\u8bf7\u6c42SAP\u4ea4\u4e92URL:{},XML:{}", (Object)path, (Object)xml);
        HttpPost httpPost = new HttpPost(path);
        httpPost.setConfig(REQUEST_CONFIG_TIME_OUT);
        StringEntity postingString = new StringEntity(xml, StandardCharsets.UTF_8.name());
        httpPost.setEntity((HttpEntity)postingString);
        httpPost.setHeader("Content-Type", "text/xml; charset=utf-8");
        Result<String> bodyAsString = HttpClientUtils.execReq(httpPost);
        log.info("\u8bf7\u6c42SAP\u4ea4\u4e92\u7ed3\u679cPost Result:{}", bodyAsString);
        return bodyAsString;
    }

    public static final Result<String> doPostWebService(String path, String userName2, String passWord, String xml) {
        log.info("\u8bf7\u6c42SAP\u4ea4\u4e92URL:{} \uff5c XML:{}", (Object)path, (Object)xml);
        HttpPost httpPost = new HttpPost(path);
        String auth = userName2 + ":" + passWord;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
        String authHeader = "Basic " + new String(encodedAuth);
        httpPost.setHeader("Authorization", authHeader);
        httpPost.setConfig(REQUEST_CONFIG_TIME_OUT);
        StringEntity postingString = new StringEntity(xml, StandardCharsets.UTF_8.name());
        httpPost.setEntity((HttpEntity)postingString);
        httpPost.setHeader("Content-Type", "text/xml; charset=utf-8");
        Result<String> bodyAsString = HttpClientUtils.execReq(httpPost);
        log.info("\u8bf7\u6c42SAP\u4ea4\u4e92\u7ed3\u679cPost Result:{}", bodyAsString);
        return bodyAsString;
    }

    private static List<NameValuePair> createParams(Map<String, Object> params) {
        ArrayList nameValuePairs = Lists.newArrayList();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            nameValuePairs.add(new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue())));
        }
        return nameValuePairs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Result<String> execReq(HttpPost httpPost) {
        Result result = new Result();
        try {
            CloseableHttpResponse response = HttpClientUtils.getClient(true).execute((HttpUriRequest)httpPost);
            if (response == null) {
                result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
                result.setMessage("http post request error: " + httpPost.getURI());
                return result;
            }
            try {
                if (response.getStatusLine().getStatusCode() == 200) {
                    result.setCode(ComConstant.SC_OK_200);
                    result.setResult((Object)EntityUtils.toString((HttpEntity)response.getEntity()));
                    Result result2 = result;
                    return result2;
                }
                result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
                result.setMessage("http post request error: " + httpPost.getURI());
                Result result3 = result;
                return result3;
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (IOException e) {
            log.error("doPost error: ", (Throwable)e);
            result.setCode(ComConstant.SC_INTERNAL_SERVER_ERROR_500);
            result.setMessage(e.getMessage());
            return result;
        }
    }
}

