/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.alibaba.fastjson.JSON;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.sfa.SfaCommonEnum;
import com.biz.crm.nebular.sfa.calculateSalary.resp.SfaCalculateSalaryDateRespVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignRuleRespVo;
import com.biz.crm.nebular.sfa.worksignrule.resp.SfaWorkSignSpecialRespVo;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class SfaSignUtils {
    public static final String TIME_TYPE_ALL_STR = "1,2,3";

    public static long verifyStartAndEndDate(String startDate, String endDate) {
        try {
            LocalDate.parse(startDate);
        }
        catch (Exception e) {
            throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u9519\u8bef\u3002\u65e5\u671f\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd");
        }
        try {
            LocalDate.parse(endDate);
        }
        catch (Exception e) {
            throw new BusinessException("\u7ed3\u675f\u65f6\u95f4\u9519\u8bef\u3002\u65e5\u671f\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd");
        }
        long intervalNum = LocalDate.parse(startDate).until(LocalDate.parse(endDate), ChronoUnit.DAYS);
        if (intervalNum < 0L) {
            throw new BusinessException("\u5f00\u59cb\u65f6\u95f4\u8d85\u8fc7\u7ed3\u675f\u65f6\u95f4");
        }
        return intervalNum;
    }

    public static void verifyApply(String startDate, String endDate, List<SfaApplyTimeInfoReqVo> applyList, String applyDays) {
        BigDecimal countApplyDays = SfaSignUtils.countApplyDays(startDate, endDate, applyList);
        try {
            new BigDecimal(applyDays);
        }
        catch (Exception e) {
            throw new BusinessException("\u7533\u8bf7\u65f6\u957f\u9519\u8bef");
        }
        if (new BigDecimal(applyDays).compareTo(countApplyDays) != 0) {
            throw new BusinessException("\u7533\u8bf7\u65f6\u957f\u548c\u660e\u7ec6\u65f6\u95f4\u4e0d\u4e00\u81f4");
        }
    }

    public static void verifyApply(String startDate, String endDate, List<SfaApplyTimeInfoReqVo> applyList) {
        long intervalNum = SfaSignUtils.verifyStartAndEndDate(startDate, endDate);
        if (applyList == null || applyList.size() == 0) {
            throw new BusinessException("\u65e5\u671f\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (applyList.size() == 1) {
            if (intervalNum != 0L) {
                throw new BusinessException("\u65e5\u671f\u660e\u7ec6\u5217\u8868\u548c \u7533\u8bf7\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\u4e0d\u4e00\u81f4\u3002\u81f3\u5c11\u5305\u542b\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f\u7684\u660e\u7ec6");
            }
        } else if (applyList.size() == 2) {
            if (intervalNum == 0L) {
                throw new BusinessException("\u65e5\u671f\u660e\u7ec6\u5217\u8868\u548c \u7533\u8bf7\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\u4e0d\u4e00\u81f4\u3002\u81f3\u5c11\u5305\u542b\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f\u7684\u660e\u7ec6");
            }
        } else {
            throw new BusinessException("\u65e5\u671f\u660e\u7ec6\u5217\u8868\u53ea\u80fd\u5305\u542b\u5f00\u59cb\u548c\u7ed3\u675f\u65e5\u671f\u7684\u660e\u7ec6");
        }
        for (int r = 0; r < applyList.size(); ++r) {
            SfaApplyTimeInfoReqVo vo = applyList.get(r);
            try {
                LocalDate.parse(vo.getTimeStr());
            }
            catch (Exception e) {
                throw new BusinessException("\u65e5\u671f\u660e\u7ec6\u5217\u8868\u4e2d \u65e5\u671f \u9519\u8bef\u3002\u65e5\u671f\u683c\u5f0f\u4e3a\uff1ayyyy-MM-dd");
            }
            if (StringUtils.isEmpty((String)vo.getTimeType()) || TIME_TYPE_ALL_STR.indexOf(vo.getTimeType()) == -1) {
                throw new BusinessException("\u65e5\u671f\u660e\u7ec6\u5217\u8868\u4e2d \u65e5\u671f\u7c7b\u578b \u9519\u8bef\u3002\u65e5\u671f\u7c7b\u578b(1\u5168\u5929\uff0c2\u4e0a\u5348\uff0c3\u4e0b\u5348)");
            }
            if (r == 0) {
                if (vo.getTimeStr().equals(startDate)) continue;
                throw new BusinessException("\u65e5\u671f\u660e\u7ec6\u5217\u8868\u548c \u7533\u8bf7\u5f00\u59cb\u65f6\u95f4\u4e0d\u4e00\u81f4");
            }
            if (r == applyList.size() - 1) {
                if (vo.getTimeStr().equals(endDate)) continue;
                throw new BusinessException("\u65e5\u671f\u660e\u7ec6\u5217\u8868\u548c \u7533\u8bf7\u7ed3\u675f\u65f6\u95f4\u4e0d\u4e00\u81f4");
            }
            if (LocalDate.parse(startDate).plusDays(r).until(LocalDate.parse(vo.getTimeStr()), ChronoUnit.DAYS) == 0L) continue;
            throw new BusinessException("\u65e5\u671f\u660e\u7ec6\u5217\u8868\u548c \u7533\u8bf7\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4\u4e0d\u4e00\u81f4");
        }
    }

    public static BigDecimal countApplyDays(String startDate, String endDate, List<SfaApplyTimeInfoReqVo> applyList) {
        List<SfaApplyTimeInfoReqVo> returnList = SfaSignUtils.fillTimeInfoAndCheck(applyList, startDate, endDate);
        BigDecimal countApplyDays = new BigDecimal(0);
        for (SfaApplyTimeInfoReqVo vo : returnList) {
            if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(vo.getTimeType())) {
                countApplyDays = countApplyDays.add(new BigDecimal(1));
                continue;
            }
            countApplyDays = countApplyDays.add(new BigDecimal(0.5));
        }
        return countApplyDays;
    }

    public static List<SfaApplyTimeInfoReqVo> fillTimeInfo(List<SfaApplyTimeInfoReqVo> applyList, String startDate, String endDate) {
        ArrayList<SfaApplyTimeInfoReqVo> returnList = new ArrayList();
        long intervalNum = LocalDate.parse(startDate).until(LocalDate.parse(endDate), ChronoUnit.DAYS);
        if (intervalNum <= 1L || (long)applyList.size() == intervalNum + 1L) {
            returnList = applyList;
        } else {
            returnList.add(applyList.get(0));
            int r = 1;
            while ((long)r < intervalNum) {
                SfaApplyTimeInfoReqVo vo = new SfaApplyTimeInfoReqVo();
                vo.setTimeStr(LocalDate.parse(startDate).plusDays(r).toString());
                vo.setTimeType(SfaCommonEnum.dataTimeType.ALL_DAY.getValue());
                returnList.add(vo);
                ++r;
            }
            returnList.add(applyList.get(applyList.size() - 1));
        }
        return returnList;
    }

    public static List<SfaApplyTimeInfoReqVo> fillTimeInfoAndCheck(List<SfaApplyTimeInfoReqVo> applyList, String startDate, String endDate) {
        SfaSignUtils.verifyApply(startDate, endDate, applyList);
        return SfaSignUtils.fillTimeInfo(applyList, startDate, endDate);
    }

    public static void main(String[] args) {
        System.out.println(LocalDate.parse("2021-04-27").until(LocalDate.parse("2021-04-29"), ChronoUnit.DAYS));
    }

    public static List<SfaApplyTimeInfoReqVo> createNewTimeInfo(String startDate, String endDate, List<SfaApplyTimeInfoReqVo> applyList) {
        SfaApplyTimeInfoReqVo startInfo = applyList.get(0);
        SfaApplyTimeInfoReqVo endInfo = applyList.get(applyList.size() - 1);
        if (StringUtils.isNotBlank((String)startDate)) {
            LocalDate start = LocalDate.parse(startDate);
            if (start.isAfter(LocalDate.parse(endInfo.getTimeStr()))) {
                return null;
            }
            if (start.isAfter(LocalDate.parse(startInfo.getTimeStr()))) {
                startInfo = new SfaApplyTimeInfoReqVo(startDate, SfaCommonEnum.dataTimeType.ALL_DAY.getValue());
            }
        }
        if (StringUtils.isNotBlank((String)endDate)) {
            LocalDate end = LocalDate.parse(endDate);
            if (end.isBefore(LocalDate.parse(startInfo.getTimeStr()))) {
                return null;
            }
            if (end.isBefore(LocalDate.parse(endInfo.getTimeStr()))) {
                endInfo = new SfaApplyTimeInfoReqVo(endDate, SfaCommonEnum.dataTimeType.ALL_DAY.getValue());
            }
        }
        ArrayList<SfaApplyTimeInfoReqVo> result = new ArrayList<SfaApplyTimeInfoReqVo>();
        result.add(startInfo);
        if (!startInfo.getTimeStr().equals(endInfo.getTimeStr())) {
            result.add(endInfo);
        }
        return result;
    }

    public static BigDecimal countCreateNewTimeInfo(String startDate, String endDate, List<SfaApplyTimeInfoReqVo> applyList) {
        List<SfaApplyTimeInfoReqVo> list = SfaSignUtils.createNewTimeInfo(startDate, endDate, applyList);
        if (list == null) {
            return new BigDecimal(0);
        }
        return SfaSignUtils.countApplyDays(list.get(0).getTimeStr(), list.get(list.size() - 1).getTimeStr(), list);
    }

    public static void verifyDateRepeat(String applyBeginTime, String applyEndTime, String beginTime, String endTime, List<SfaApplyTimeInfoReqVo> applyTimeInfoList, List<SfaApplyTimeInfoReqVo> timeInfoList) {
        if (LocalDate.parse(applyBeginTime).isAfter(LocalDate.parse(endTime)) || LocalDate.parse(applyEndTime).isBefore(LocalDate.parse(beginTime))) {
            return;
        }
        String startDate = "";
        String endDate = "";
        startDate = LocalDate.parse(applyBeginTime).isAfter(LocalDate.parse(beginTime)) ? applyBeginTime : beginTime;
        if (startDate.equals(endDate = LocalDate.parse(applyEndTime).isAfter(LocalDate.parse(endTime)) ? endTime : applyEndTime)) {
            timeInfoList = SfaSignUtils.fillTimeInfoAndCheck(timeInfoList, timeInfoList.get(0).getTimeStr(), timeInfoList.get(timeInfoList.size() - 1).getTimeStr());
            for (SfaApplyTimeInfoReqVo info : timeInfoList) {
                if (!info.getTimeStr().equals(startDate)) continue;
                if (SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(info.getTimeType())) {
                    throw new BusinessException("\u5df2\u5b58\u5728" + info.getTimeStr() + "\u7684\u7533\u8bf7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65e5\u671f\uff01");
                }
                for (SfaApplyTimeInfoReqVo nowInfo : applyTimeInfoList) {
                    if (!info.getTimeStr().equals(nowInfo.getTimeStr()) || !SfaCommonEnum.dataTimeType.ALL_DAY.getValue().equals(nowInfo.getTimeType()) && !info.getTimeType().equals(nowInfo.getTimeType())) continue;
                    throw new BusinessException("\u5df2\u5b58\u5728" + info.getTimeStr() + "\u7684\u7533\u8bf7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65e5\u671f\uff01");
                }
            }
        } else {
            throw new BusinessException("\u5df2\u5b58\u5728" + startDate + "\u81f3" + endDate + "\u7684\u7533\u8bf7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u65e5\u671f\uff01");
        }
    }

    public static String isWorkDay(SfaWorkSignRuleRespVo rule, String date, List<SfaCalculateSalaryDateRespVo> holidayList) {
        if (YesNoEnum.yesNoEnum.YES.getValue().equals(rule.getHolidayWhether())) {
            if (holidayList == null || holidayList.size() == 0 || holidayList.get(0) == null) {
                throw new BusinessException("\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e" + LocalDate.parse(date).getYear() + "\u5e74\u5ea6\u8282\u5047\u65e5\u4fe1\u606f");
            }
            List incloudHolidayList = holidayList.stream().filter(vo -> vo.getDay().equals(date)).collect(Collectors.toList());
            if (incloudHolidayList != null && incloudHolidayList.size() > 0) {
                for (SfaCalculateSalaryDateRespVo vo2 : incloudHolidayList) {
                    if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(vo2.getIsCalculationSalary())) continue;
                    return YesNoEnum.yesNoEnum.THREE.getValue();
                }
                return YesNoEnum.yesNoEnum.TWO.getValue();
            }
        }
        if (rule.getSfaWorkSignSpecialMustRespVos() != null) {
            for (SfaWorkSignSpecialRespVo vo3 : rule.getSfaWorkSignSpecialMustRespVos()) {
                if (!vo3.getWssDate().equals(date)) continue;
                return YesNoEnum.yesNoEnum.ZERO.getValue();
            }
        }
        LocalDate localDate = LocalDate.parse(date);
        if (rule.getWorkingDay().indexOf(localDate.getDayOfWeek().getValue() + "") == -1) {
            return YesNoEnum.yesNoEnum.ONE.getValue();
        }
        return YesNoEnum.yesNoEnum.ZERO.getValue();
    }

    public static String addDeductionIds(String old, String id, BigDecimal days) {
        List<HashMap<String, BigDecimal>> list = new ArrayList();
        if (StringUtils.isNotBlank((String)old)) {
            list = JSON.parseArray((String)old, Map.class);
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put(id, days);
        list.add(map);
        return JSON.toJSONString(list);
    }

    public static String backDeductionIds(String deductionIds, String id, BigDecimal days) {
        ArrayList<Map> result = new ArrayList<Map>();
        List<Map> list = SfaSignUtils.decodeDeductionIds(deductionIds);
        for (Map map : list) {
            String oldId = SfaSignUtils.getDeductionId(map);
            BigDecimal oldDays = SfaSignUtils.getDeductionDays(map);
            if (oldId.equals(id)) {
                if ((days = oldDays.subtract(days)).compareTo(BigDecimal.ZERO) == 0) continue;
                map.put(id, days);
            }
            result.add(map);
        }
        return JSON.toJSONString(list);
    }

    public static List<Map> decodeDeductionIds(String deductionIds) {
        return JSON.parseArray((String)deductionIds, Map.class);
    }

    public static BigDecimal getDeductionDays(Map map) {
        Iterator iterator = map.values().iterator();
        if (iterator.hasNext()) {
            Object value = iterator.next();
            return new BigDecimal(value.toString());
        }
        return new BigDecimal(0);
    }

    public static String getDeductionId(Map map) {
        Iterator iterator = map.keySet().iterator();
        if (iterator.hasNext()) {
            Object key = iterator.next();
            return key.toString();
        }
        return "";
    }
}

