/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.base.BusinessException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlBeanUtil {
    private static final Logger log = LoggerFactory.getLogger(XmlBeanUtil.class);

    public static String beanToXml(Object obj, String encoding) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            StringWriter writer = new StringWriter();
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.FALSE);
            if (StringUtils.isNotBlank((CharSequence)encoding)) {
                marshaller.setProperty("jaxb.encoding", (Object)encoding);
            }
            marshaller.marshal(obj, (Writer)writer);
            return writer.toString();
        }
        catch (JAXBException e) {
            log.error("marshaller Bean-->Xml error:", (Throwable)e);
            throw new BusinessException("\u5bf9\u8c61\u8f6cxml\u5f02\u5e38!");
        }
    }

    public static <T> T xmlToBean(String xml, Class<T> t) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{t});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (T)unmarshaller.unmarshal((Reader)new StringReader(xml));
        }
        catch (JAXBException e) {
            log.error("Xml -> marshaller Bean error:", (Throwable)e);
            throw new BusinessException("XML\u8f6c\u6362\u5bf9\u8c61\u5931\u8d25!");
        }
    }
}

