/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util.fee;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CodeUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FeePoolRollbackUtil {
    public static final String FEE_POOL_TEMP_REDIS_KEY = "FEE_POOL_TEMP_REDIS_KEY:";
    public static final String FEE_POOL_ACCOUNT_THREAD_LOCAL_KEY = "FEE_POOL_ACCOUNT_THREAD_LOCAL_KEY";
    private static RedisService redisService;

    @Autowired
    public void setRedisService(RedisService redis) {
        redisService = redis;
    }

    public static void addRollbackOperationCode(String operationCode) {
        Object o = ThreadLocalUtil.get((String)FEE_POOL_ACCOUNT_THREAD_LOCAL_KEY);
        List<String> list = o == null ? new ArrayList() : (List)o;
        list.add(operationCode);
        ThreadLocalUtil.set((String)FEE_POOL_ACCOUNT_THREAD_LOCAL_KEY, list);
    }

    public static String generateRollbackCode() {
        Object o = ThreadLocalUtil.get((String)FEE_POOL_ACCOUNT_THREAD_LOCAL_KEY);
        List list = o == null ? new ArrayList() : (List)o;
        String rollbackCode = CodeUtil.getCodeDefault();
        redisService.setSeconds(FEE_POOL_TEMP_REDIS_KEY + rollbackCode, list, 60L);
        return rollbackCode;
    }

    public static List<String> getOperationCodeListByRollbackCode(String rollbackCode) {
        Object o = redisService.get(FEE_POOL_TEMP_REDIS_KEY + rollbackCode);
        if (o != null) {
            return (List)o;
        }
        return new ArrayList<String>();
    }

    public static void removeRollbackCode(String rollbackCode) {
        redisService.del(new String[]{FEE_POOL_TEMP_REDIS_KEY + rollbackCode});
    }
}

