/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.wx;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.config.resttemplate.RestTemplateUtils;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.req.MdmBugListManagementReqVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class WxMsgUtil {
    private static final Logger log = LoggerFactory.getLogger(WxMsgUtil.class);
    public static final String markdown = "markdown";
    public static final String text = "text";
    private static String wxUrl;
    @Value(value="${WxMsgUrl:}")
    private String wxMsgUrl;

    @PostConstruct
    public void setUrl() {
        wxUrl = StringUtils.isEmpty((CharSequence)this.wxMsgUrl) ? "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=e6170edb-0633-4601-ad0e-7c9ec4dc834f" : this.wxMsgUrl;
    }

    public static void sendMarkdownMsg(String msg) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype", (Object)markdown);
        JSONObject markdown = new JSONObject();
        markdown.put("content", (Object)msg);
        jsonObject.put(markdown, (Object)markdown);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        ResponseEntity<Result> response = RestTemplateUtils.postForEntity(wxUrl, headers, jsonObject, Result.class);
    }

    public static void sendBugMsg(MdmBugListManagementReqVo reqVo) {
        StringBuilder stringBuffer = new StringBuilder();
        try {
            stringBuffer.append(reqVo.getChargeMan() + " \u60a8\u6709\u65b0\u7684\u52a0\u6025\u5904\u7406\u7985\u9053\u4e8b\u9879,\u7f16\u7801:" + reqVo.getBugCode());
        }
        catch (Exception e) {
            log.error("\u6d88\u606f\u5fae\u4fe1\u63a8\u9001\u5931\u8d25", (Throwable)e);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype", (Object)text);
        JSONObject text = new JSONObject();
        text.put("mentioned_mobile_list", (Object)Lists.newArrayList((Object[])new String[]{reqVo.getCodeByPhone()}));
        text.put("content", (Object)stringBuffer.toString());
        jsonObject.put(text, (Object)text);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        ResponseEntity<Result> response = RestTemplateUtils.postForEntity(wxUrl, headers, jsonObject, Result.class);
    }

    public static void sendTextMsg(String msg) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("msgtype", (Object)text);
        JSONObject text = new JSONObject();
        text.put("content", (Object)msg);
        jsonObject.put(text, (Object)text);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        ResponseEntity<Result> response = RestTemplateUtils.postForEntity(wxUrl, headers, jsonObject, Result.class);
    }
}

