/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config.resttemplate;

import com.biz.crm.config.resttemplate.HttpsClientRequestFactory;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
public class RestTemplateUtils {
    private static final Logger log = LoggerFactory.getLogger(RestTemplateUtils.class);

    public static RestTemplate geTemplate() {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new HttpsClientRequestFactory());
        restTemplate.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemplate;
    }

    public static <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Map<String, ?> uriVariables) {
        return RestTemplateUtils.geTemplate().getForEntity(url, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> postForEntity(String url, HttpHeaders headers, Object requestBody, Class<T> responseType) {
        if (headers == null) {
            headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        }
        log.info(url);
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity data = RestTemplateUtils.geTemplate().postForEntity(url, (Object)requestEntity, responseType, new Object[0]);
        return data;
    }

    public static String postForObject(String url, HttpEntity httpEntity) {
        return (String)RestTemplateUtils.geTemplate().postForObject(url, (Object)httpEntity, String.class, new Object[0]);
    }

    public <T> ResponseEntity<T> get(String url, Class<T> responseType) throws RestClientException {
        return RestTemplateUtils.geTemplate().getForEntity(url, responseType, new Object[0]);
    }

    public <T> ResponseEntity<T> get(String url, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().getForEntity(url, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> get(String url, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().getForEntity(url, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> get(String url, Map<String, String> headers, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.get(url, httpHeaders, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> get(String url, HttpHeaders headers, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return this.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> get(String url, Map<String, String> headers, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.get(url, httpHeaders, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> get(String url, HttpHeaders headers, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return this.exchange(url, HttpMethod.GET, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, Class<T> responseType) throws RestClientException {
        return RestTemplateUtils.geTemplate().postForEntity(url, (Object)HttpEntity.EMPTY, responseType, new Object[0]);
    }

    public <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType) throws RestClientException {
        return RestTemplateUtils.geTemplate().postForEntity(url, requestBody, responseType, new Object[0]);
    }

    public <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().postForEntity(url, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().postForEntity(url, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.post(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.post(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.post(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.post(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().exchange(url, HttpMethod.POST, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> post(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().exchange(url, HttpMethod.POST, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return this.put(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return this.put(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return this.put(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.put(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.put(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.put(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.put(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().exchange(url, HttpMethod.PUT, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> put(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().exchange(url, HttpMethod.PUT, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return this.delete(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return this.delete(url, HttpEntity.EMPTY, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Object requestBody, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity(requestBody);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.delete(url, httpHeaders, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.delete(url, httpHeaders, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.delete(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, Map<String, String> headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setAll(headers);
        return this.delete(url, httpHeaders, requestBody, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpHeaders headers, Object requestBody, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return this.delete(url, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().exchange(url, HttpMethod.DELETE, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> delete(String url, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().exchange(url, HttpMethod.DELETE, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return RestTemplateUtils.geTemplate().exchange(url, method, requestEntity, responseType, uriVariables);
    }

    public static <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpHeaders headers, Object requestBody, ParameterizedTypeReference<T> parameterizedTypeReference) throws RestClientException {
        if (headers == null) {
            headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        }
        HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
        return RestTemplateUtils.geTemplate().exchange(url, method, requestEntity, parameterizedTypeReference, new Object[0]);
    }
}

