/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.biz.crm.config.KlockConfig;
import com.biz.crm.core.BusinessKeyProvider;
import com.biz.crm.core.KlockAspectHandler;
import com.biz.crm.core.LockInfoProvider;
import com.biz.crm.lock.LockFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnProperty(prefix="spring.klock", name={"enable"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={KlockConfig.class})
@Import(value={KlockAspectHandler.class})
public class RedissonConfig {
    @Autowired
    private KlockConfig klockConfig;

    @Bean(destroyMethod="shutdown")
    RedissonClient redisson() throws Exception {
        Config config = new Config();
        if (this.klockConfig.getClusterServer() != null) {
            ((ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().setPassword(this.klockConfig.getPassword())).setPingConnectionInterval(1000)).setRetryInterval(1000)).addNodeAddress(this.klockConfig.getClusterServer().getNodeAddresses());
        } else {
            ((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(this.klockConfig.getAddress()).setPingConnectionInterval(1000)).setRetryInterval(1000)).setDatabase(this.klockConfig.getDatabase()).setPassword(this.klockConfig.getPassword());
        }
        Codec codec = (Codec)ClassUtils.forName((String)this.klockConfig.getCodec(), (ClassLoader)ClassUtils.getDefaultClassLoader()).newInstance();
        config.setCodec(codec);
        config.setEventLoopGroup((EventLoopGroup)new NioEventLoopGroup());
        return Redisson.create((Config)config);
    }

    @Bean
    public LockInfoProvider lockInfoProvider() {
        return new LockInfoProvider();
    }

    @Bean
    public BusinessKeyProvider businessKeyProvider() {
        return new BusinessKeyProvider();
    }

    @Bean
    public LockFactory lockFactory() {
        return new LockFactory();
    }
}

