/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.biz.crm.config.LoginInterceptor;
import com.biz.crm.config.ResultResponseInterceptor;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;

@Configuration
public class WebConfig
extends WebMvcConfigurationSupport {
    @Value(value="${spring.resources.static-locations:}")
    private String[] resourceslocations;
    @Value(value="${crm.whitelist:}")
    private String[] whiteList;
    @Value(value="${oss.localPath:}")
    private String localPath;
    @Autowired
    private ResultResponseInterceptor resultResponseInterceptor;

    @Bean
    LoginInterceptor loginInterceptor() {
        return new LoginInterceptor();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        ArrayList<String> excludeUrl = new ArrayList<String>();
        if (this.resourceslocations != null) {
            for (String temp : this.resourceslocations) {
                if (!StringUtils.isNotEmpty((String)temp)) continue;
                excludeUrl.add(temp);
            }
        }
        if (this.whiteList != null) {
            for (String temp : this.whiteList) {
                if (!StringUtils.isNotEmpty((String)temp)) continue;
                excludeUrl.add(temp);
            }
        }
        registry.addInterceptor((HandlerInterceptor)this.loginInterceptor()).excludePathPatterns(excludeUrl);
    }

    protected void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/activitipage/**"}).addResourceLocations(new String[]{"classpath:/activitipage/"});
        registry.addResourceHandler(new String[]{"/doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        if (StringUtils.isNotEmpty((String)this.localPath)) {
            registry.addResourceHandler(new String[]{"/crmfile/**"}).addResourceLocations(new String[]{"file:" + this.localPath});
        }
        super.addResourceHandlers(registry);
    }
}

