/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util.es.permission;

import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.util.es.permission.EsDataPermission;
import com.biz.crm.util.es.permission.EsDataPermissionResolver;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class EsDataPermissionAspect {
    private static final Logger log = LoggerFactory.getLogger(EsDataPermissionAspect.class);
    public static final String ES_DATA_PERMISSION_KEY = "ES_DATA_PERMISSION_KEY";

    @Before(value="@annotation(EsDataPermission)")
    public void doBefore(JoinPoint joinPoint) throws NoSuchMethodException {
        Class<?> clazz = joinPoint.getTarget().getClass();
        String methodName = joinPoint.getSignature().getName();
        Class<?>[] parameterTypes = ((MethodSignature)joinPoint.getSignature()).getMethod().getParameterTypes();
        Method method = clazz.getMethod(methodName, parameterTypes);
        EsDataPermission permission = method.getAnnotation(EsDataPermission.class);
        ConcurrentHashMap<String, EsDataPermissionResolver> map = ThreadLocalUtil.get();
        if (null == map) {
            map = new ConcurrentHashMap<String, EsDataPermissionResolver>();
        }
        map.put(ES_DATA_PERMISSION_KEY, new EsDataPermissionResolver(permission));
        ThreadLocalUtil.stObj(map);
    }

    @AfterReturning(returning="ret", pointcut="@annotation(EsDataPermission)")
    public void doAfterReturning(Object ret) {
        ThreadLocalUtil.delObj();
    }

    @AfterThrowing(value="@annotation(EsDataPermission)", throwing="throwable")
    public void doAfterThrowing(Throwable throwable) {
        ThreadLocalUtil.delObj();
    }
}

