/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyProduct;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyProductEditVo;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.biz.crm.promotion.mapper.PromotionPolicyProductMapper;
import com.biz.crm.promotion.service.PromotionPolicyProductService;
import com.biz.crm.util.CommonConstant;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
@ConditionalOnMissingBean(name={"promotionPolicyProductServiceExpand"})
@Service(value="promotionPolicyProductService")
public class PromotionPolicyProductServiceImpl
extends ServiceImpl<PromotionPolicyProductMapper, PromotionPolicyProductEntity>
implements PromotionPolicyProductService {
    @Resource
    private PromotionPolicyProductMapper promotionPolicyProductMapper;

    @Override
    public void refreshProduct(PromotionPolicyEditReqVo editVo) {
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            this.doDelByPromotionPolicyIdOrCode(Lists.newArrayList((Object[])new String[]{editVo.getId()}), null);
        }
        List tempEditVos = editVo.takeAllProducts();
        ArrayList editVos = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)tempEditVos)) {
            return;
        }
        HashSet keys = Sets.newHashSet();
        for (PromotionPolicyProductEditVo temp : tempEditVos) {
            String key = temp.getPromotionPolicyId() + temp.getProductCode() + temp.getCurrentProduct();
            if (keys.contains(key)) continue;
            temp.setId(null);
            temp.setPromotionPolicyCode(editVo.getPromotionPolicyCode());
            temp.setPromotionPolicyId(editVo.getId());
            temp.setPromotionPolicyName(editVo.getPromotionPolicyName());
            editVos.add(temp);
            keys.add(key);
        }
        this.saveBatch(CrmBeanUtil.copyList((List)editVos, PromotionPolicyProductEntity.class));
    }

    @Override
    public void loadListForEditPromotionPolicy(PromotionPolicyEditVo editVo) {
        List<PromotionPolicyProductEntity> y = null;
        List<PromotionPolicyProductEntity> n = null;
        if (StringUtils.isNotBlank((CharSequence)editVo.getId())) {
            QueryWrapper wrapper = Wrappers.query();
            wrapper.in((Object)"promotion_policy_id", new Object[]{editVo.getId()});
            Map<String, List<PromotionPolicyProductEntity>> groupByCurrentProduct = this.promotionPolicyProductMapper.selectList((Wrapper)wrapper).stream().collect(Collectors.groupingBy(PromotionPolicyProductEntity::getCurrentProduct));
            y = groupByCurrentProduct.get(CommonConstant.GLOBAL.YesOrNo.Y.getItemCode());
            n = groupByCurrentProduct.get(CommonConstant.GLOBAL.YesOrNo.N.getItemCode());
        }
        PromotionPolicyProduct promotionPolicyProduct = new PromotionPolicyProduct();
        promotionPolicyProduct.setProductsCurrentY(CrmBeanUtil.copyList(y, PromotionPolicyProductEditVo.class));
        promotionPolicyProduct.setProductsCurrentN(CrmBeanUtil.copyList(n, PromotionPolicyProductEditVo.class));
        editVo.setPromotionPolicyProduct(promotionPolicyProduct);
    }

    @Override
    public void delByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        this.doDelByPromotionPolicyIdOrCode(promotionPolicyId, promotionPolicyCode);
    }

    @Override
    public Set<String> selectPromotionPolicyIdByProductCode(String productCode) {
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet(this.promotionPolicyProductMapper.selectPromotionPolicyIdByProductCode(productCode));
    }

    @Override
    public List<PromotionPolicyProductEntity> selectPromotionPolicyIdByProductCodes(List<String> productCodes) {
        return this.promotionPolicyProductMapper.selectPromotionPolicyIdByProductCodes(productCodes);
    }

    private void doDelByPromotionPolicyIdOrCode(List<String> promotionPolicyId, List<String> promotionPolicyCode) {
        QueryWrapper wrapper = Wrappers.query();
        if (!CollectionUtils.isEmpty(promotionPolicyId)) {
            wrapper.in((Object)"promotion_policy_id", promotionPolicyId);
        } else if (!CollectionUtils.isEmpty(promotionPolicyCode)) {
            wrapper.in((Object)"promotion_policy_code", promotionPolicyCode);
        } else {
            return;
        }
        this.promotionPolicyProductMapper.delete((Wrapper)wrapper);
    }
}

