/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.feepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.feepool.entity.FeePoolEntity;
import com.biz.crm.feepool.mapper.FeePoolDetailMapper;
import com.biz.crm.feepool.mapper.FeePoolMapper;
import com.biz.crm.feepool.service.FeePoolDetailService;
import com.biz.crm.feepool.service.FeePoolService;
import com.biz.crm.feepool.utils.FeePoolDetailLogUtil;
import com.biz.crm.nebular.dms.feepool.FeePoolDetailVo;
import com.biz.crm.nebular.dms.feepool.FeePoolVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.DmsConstant;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ValidateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"feePoolServiceExpandImpl"})
@Service(value="feePoolService")
public class FeePoolServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<FeePoolMapper, FeePoolEntity>
implements FeePoolService {
    @Autowired
    private FeePoolMapper feePoolMapper;
    @Autowired
    private FeePoolDetailMapper feePoolDetailMapper;
    @Resource
    private FeePoolDetailService feePoolDetailService;

    @Override
    @Transactional
    public void add(FeePoolVo vo) {
        ValidateUtils.validate((Object)vo.getCusCode(), (String)"\u5546\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getCusName(), (String)"\u5546\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getCusOrgCode(), (String)"\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getCusOrgName(), (String)"\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getCusChannelCode(), (String)"\u5ba2\u6237\u6240\u5c5e\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getCusChannelName(), (String)"\u5ba2\u6237\u6240\u5c5e\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"cus_code", (Object)vo.getCusCode());
        List entities = this.feePoolMapper.selectList((Wrapper)wrapper);
        if (!CollectionUtils.isEmpty((Collection)entities)) {
            throw new BusinessException("\u8be5\u5546\u6237\u8d39\u7528\u6c60\u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u65b0\u6dfb\u52a0!");
        }
        FeePoolDetailVo feePoolDetailVo = (FeePoolDetailVo)vo.getDetails().get(0);
        if (feePoolDetailVo.getBalance().compareTo(BigDecimal.ZERO) < 0) {
            throw new BusinessException("\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f!");
        }
        FeePoolEntity entity = new FeePoolEntity();
        BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
        entity.setTotal(feePoolDetailVo.getBalance());
        entity.setBalance(feePoolDetailVo.getBalance());
        entity.setCode(CodeUtil.createCode());
        this.feePoolMapper.insert((Object)entity);
        ArrayList<FeePoolDetailVo> feePoolDetailVos = new ArrayList<FeePoolDetailVo>();
        feePoolDetailVo.setAdjustmentType(FeePoolDetailLogUtil.ADJUSTMENTTYPE.INITIAL.getCode());
        feePoolDetailVos.add(feePoolDetailVo);
        this.feePoolDetailService.addBatch(feePoolDetailVos, entity);
    }

    @Override
    @Transactional
    public void adjust(final FeePoolVo feePoolVo) {
        List detailEntities;
        List details = feePoolVo.getDetails();
        if (CollectionUtils.isEmpty((Collection)details)) {
            throw new BusinessException("\u8d39\u7528\u6c60\u6761\u76ee\u4e3a\u7a7a!");
        }
        ValidateUtils.validate((Object)feePoolVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8c03\u6574\u7684\u8d39\u7528\u6c60");
        FeePoolEntity entity = (FeePoolEntity)((Object)this.feePoolMapper.selectById((Serializable)((Object)feePoolVo.getId())));
        if (null == entity) {
            throw new BusinessException("\u8be5\u8d39\u7528\u6c60\u6216\u5df2\u88ab\u5220\u9664\uff01");
        }
        List discountList = details.stream().filter(vo -> vo.getPayType().intValue() == DmsConstant.PAYTYPE.DISCOUNT.getCode().intValue()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(discountList) && discountList.size() > 1) {
            throw new BusinessException("\u540c\u4e00\u4e2a\u7ecf\u9500\u5546\u53ea\u80fd\u62e5\u6709\u4e00\u4e2a\u6298\u6263\u8d39\u7528\u6c60\u6761\u76ee\uff01");
        }
        if (!CollectionUtils.isEmpty(discountList) && discountList.size() == 1 && !CollectionUtils.isEmpty((Collection)(detailEntities = this.feePoolDetailMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("pay_type", DmsConstant.PAYTYPE.DISCOUNT.getCode());
                this.put("fee_pool_code", feePoolVo.getCode());
            }
        })))) {
            throw new BusinessException("\u540c\u4e00\u4e2a\u7ecf\u9500\u5546\u53ea\u80fd\u62e5\u6709\u4e00\u4e2a\u6298\u6263\u8d39\u7528\u6c60\u6761\u76ee,\u8be5\u7ecf\u9500\u5546\u5df2\u7ecf\u62e5\u6709\u6298\u6263\u8d39\u7528\u6c60\u6761\u76ee\uff01");
        }
        List<FeePoolDetailVo> addVos = details.stream().filter(vo -> vo.getId() == null).collect(Collectors.toList());
        List<FeePoolDetailVo> updateVos = details.stream().filter(vo -> vo.getId() != null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(addVos)) {
            for (FeePoolDetailVo vo2 : addVos) {
                vo2.setBalance(vo2.getAdjustmentAmount());
            }
        }
        Map<String, BigDecimal> addTotalMap = this.feePoolDetailService.addBatch(addVos, entity);
        Map<String, BigDecimal> updateTotalMap = this.feePoolDetailService.updateBatch(updateVos, entity);
        entity.setTotal(entity.getTotal().add(addTotalMap.get("add")).add(updateTotalMap.get("add")));
        entity.setBalance(entity.getBalance().subtract(addTotalMap.get("sub")).add(updateTotalMap.get("sub")));
        this.feePoolMapper.updateById((Object)entity);
    }

    @Override
    public PageResult<FeePoolVo> list(FeePoolVo feePoolVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)feePoolVo.getCusName()), (Object)"cus_name", (Object)feePoolVo.getCusName())).like(!StringUtils.isEmpty((Object)feePoolVo.getCusCode()), (Object)"cus_code", (Object)feePoolVo.getCusCode())).like(!StringUtils.isEmpty((Object)feePoolVo.getCusChannelName()), (Object)"cus_channel_name", (Object)feePoolVo.getCusChannelName())).eq(!StringUtils.isEmpty((Object)feePoolVo.getCusChannelCode()), (Object)"cus_channel_code", (Object)feePoolVo.getCusChannelCode())).like(!StringUtils.isEmpty((Object)feePoolVo.getCusOrgName()), (Object)"cus_org_name", (Object)feePoolVo.getCusOrgName())).eq(!StringUtils.isEmpty((Object)feePoolVo.getCusOrgCode()), (Object)"cus_org_code", (Object)feePoolVo.getCusOrgCode())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)feePoolVo.getPageNum(), (Integer)feePoolVo.getPageSize());
        List<FeePoolVo> list = this.feePoolMapper.list(page, (QueryWrapper<FeePoolVo>)wrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public BigDecimal findMyFeeAmount(final String cusCode) {
        BigDecimal reNum = BigDecimal.ZERO;
        List entities = this.feePoolMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("cus_code", cusCode);
            }
        });
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return reNum;
        }
        return ((FeePoolEntity)((Object)entities.get(0))).getBalance();
    }
}

