/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.impl;

import com.biz.crm.nebular.dms.promotion.ConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.promotion.entity.PromotionPolicyProductEntity;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class LoadConfigInfoContext {
    private ConfigInfoQueryVo configInfoQueryVo;
    private Map<String, List<PromotionPolicyInfoVo>> productMapPromotionPolicy = Maps.newHashMap();
    private Set<String> promotionPolicyIds = Sets.newHashSet();
    private Map<String, Map<String, BigDecimal>> productsOrderBuyMap = Maps.newHashMap();
    private Map<String, Map<String, PromotionPolicyProductEntity>> currentProductY;
    private Map<String, Map<String, PromotionPolicyProductEntity>> currentProductN;
    private Set<String> currentProductCodesN;
    private Map<String, MdmProductRespVo> currentProductInfoNMap;

    public LoadConfigInfoContext(ConfigInfoQueryVo configInfoQueryVo) {
        List orderProductInfos;
        this.configInfoQueryVo = configInfoQueryVo;
        if (null != this.configInfoQueryVo && null != (orderProductInfos = this.configInfoQueryVo.getOrderProductInfos())) {
            orderProductInfos.forEach(v -> this.productsOrderBuyMap.put(v.getProductCode(), v.getProductBuyMap()));
        }
    }

    public void putPromotionPolicyInfoVos(String productCode, List<PromotionPolicyInfoVo> promotionPolicyInfoVos) {
        if (StringUtils.isBlank((CharSequence)productCode)) {
            return;
        }
        this.productMapPromotionPolicy.put(productCode, promotionPolicyInfoVos);
        if (CollectionUtils.isEmpty(promotionPolicyInfoVos)) {
            return;
        }
        this.promotionPolicyIds.addAll(promotionPolicyInfoVos.stream().map(UuidVo::getId).collect(Collectors.toSet()));
    }

    public ConfigInfoQueryVo getConfigInfoQueryVo() {
        return this.configInfoQueryVo;
    }

    public void setConfigInfoQueryVo(ConfigInfoQueryVo configInfoQueryVo) {
        this.configInfoQueryVo = configInfoQueryVo;
    }

    public Map<String, List<PromotionPolicyInfoVo>> getProductMapPromotionPolicy() {
        return this.productMapPromotionPolicy;
    }

    public Set<String> getPromotionPolicyIds() {
        return this.promotionPolicyIds;
    }

    public Map<String, Map<String, BigDecimal>> getProductsOrderBuyMap() {
        return this.productsOrderBuyMap;
    }

    public void setProductsOrderBuyMap(Map<String, Map<String, BigDecimal>> productsOrderBuyMap) {
        this.productsOrderBuyMap = productsOrderBuyMap;
    }

    public Map<String, Map<String, PromotionPolicyProductEntity>> getCurrentProductY() {
        return this.currentProductY;
    }

    public void setCurrentProductY(Map<String, Map<String, PromotionPolicyProductEntity>> currentProductY) {
        this.currentProductY = currentProductY;
    }

    public Map<String, Map<String, PromotionPolicyProductEntity>> getCurrentProductN() {
        return this.currentProductN;
    }

    public void setCurrentProductN(Map<String, Map<String, PromotionPolicyProductEntity>> currentProductN) {
        this.currentProductN = currentProductN;
    }

    public Set<String> getCurrentProductCodesN() {
        return this.currentProductCodesN;
    }

    public void setCurrentProductCodesN(Set<String> currentProductCodesN) {
        this.currentProductCodesN = currentProductCodesN;
    }

    public Map<String, MdmProductRespVo> getCurrentProductInfoNMap() {
        return this.currentProductInfoNMap;
    }

    public void setCurrentProductInfoNMap(Map<String, MdmProductRespVo> currentProductInfoNMap) {
        this.currentProductInfoNMap = currentProductInfoNMap;
    }
}

