/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldHandleUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldHandleUtil.class);

    public static void initCreateFields(Object vo) {
        if (vo == null || !(vo instanceof CrmBaseVo) && !(vo instanceof CrmBaseEntity)) {
            return;
        }
        try {
            String[] timeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()).split(" ");
            UserRedis user = UserUtils.getUser();
            if (user == null) {
                return;
            }
            HashMap attributes = Maps.newHashMap();
            attributes.put("delFlag", "1");
            attributes.put("enableStatus", "1");
            attributes.put("createDate", timeStr[0]);
            attributes.put("createDateSecond", timeStr[1]);
            attributes.put("createCode", user.getCustcode());
            attributes.put("createName", user.getCustname());
            attributes.put("createOrgCode", user.getOrgcode());
            attributes.put("createOrgName", user.getOrgname());
            attributes.put("createPosCode", user.getPoscode());
            attributes.put("createPosName", user.getPosname());
            FieldHandleUtil.setValue(attributes, vo);
        }
        catch (Exception e) {
            throw new BusinessException("\u5904\u7406\u516c\u5171\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
        }
    }

    private static void setValue(Map<String, Object> attributes, Object vo) throws IllegalAccessException {
        List<Field> fields = FieldHandleUtil.getFields(vo.getClass());
        HashMap fieldMap = Maps.newHashMap();
        fields.forEach(f -> fieldMap.put(f.getName(), f));
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Field field = (Field)fieldMap.get(entry.getKey());
            if (field == null) continue;
            field.setAccessible(true);
            field.set(vo, entry.getValue());
        }
    }

    public static List<Field> getFields(Class c) {
        ArrayList fields = Lists.newArrayList();
        while (c != null) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
            c = c.getSuperclass();
        }
        return fields;
    }

    public static void initUpdateFields(Object vo) {
        if (vo == null || !(vo instanceof CrmBaseVo) && !(vo instanceof CrmBaseEntity)) {
            return;
        }
        try {
            String[] timeStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()).split(" ");
            UserRedis user = UserUtils.getUser();
            if (user == null) {
                return;
            }
            HashMap attributes = Maps.newHashMap();
            attributes.put("updateDate", timeStr[0]);
            attributes.put("updateDateSecond", timeStr[1]);
            attributes.put("updateCode", user.getCustcode());
            attributes.put("updateName", user.getCustname());
            attributes.put("updateOrgCode", user.getOrgcode());
            attributes.put("updateOrgName", user.getOrgname());
            attributes.put("updatePosCode", user.getPoscode());
            attributes.put("updatePosName", user.getPosname());
            FieldHandleUtil.setValue(attributes, vo);
        }
        catch (Exception e) {
            LOGGER.error("data:{}", vo);
            throw new BusinessException("\u5904\u7406\u516c\u5171\u5b57\u6bb5\u5931\u8d25", (Throwable)e);
        }
    }

    public static Map<String, Object> fieldsValue(Object o, String ... fieldNames) {
        HashMap result = Maps.newHashMap();
        try {
            Class<?> c = o.getClass();
            for (String fieldName : fieldNames) {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                result.put(fieldName, field.get(o));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Maps.newHashMap();
        }
        return result;
    }

    public static String fieldHumpToLine(String sourceName) {
        Pattern humpPattern = Pattern.compile("[A-Z]");
        Matcher matcher = humpPattern.matcher(sourceName);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String fieldLineToHump(String sourceName) {
        Pattern linePattern = Pattern.compile("_(\\w)");
        Matcher matcher = linePattern.matcher(sourceName.toLowerCase());
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static void initDecimalZero(Object v) {
        Class<?> c = v.getClass();
        try {
            Field[] fields = c.getDeclaredFields();
            if (fields == null) {
                return;
            }
            for (Field field : fields) {
                field.setAccessible(true);
                if (field.getType() != BigDecimal.class || field.get(v) != null) continue;
                field.set(v, BigDecimal.ZERO);
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("data:{}", v);
            throw new BusinessException("\u5904\u7406\u7a7a\u6570\u5b57\u5b57\u6bb5\u5f02\u5e38", (Throwable)e);
        }
    }

    public static QueryWrapper buildIndexByIndexDictCode(QueryWrapper wrapper, String indexDictCode) {
        ValidateUtils.validate((Object)wrapper, (String)"\u6839\u636e\u5b57\u5178\u6392\u5e8f\u89c4\u5219\u6784\u5efa\u67e5\u8be2\u6392\u5e8f\u6761\u4ef6\u65f6\uff0c\u6761\u4ef6\u5c01\u88c5\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165");
        ArrayList dictDataVos = DictUtil.getChildrenList((String)"fee_reduce_redtrick_rule", (String)indexDictCode);
        if (CollectionUtil.listEmpty((List)dictDataVos)) {
            DictDataVo vo1 = new DictDataVo();
            vo1.setDictCode("create_date");
            vo1.setDictValue("asc");
            vo1.setDictSort("1");
            DictDataVo vo2 = new DictDataVo();
            vo2.setDictCode("create_date_second");
            vo2.setDictValue("asc");
            vo2.setDictSort("2");
            dictDataVos = Lists.newArrayList((Object[])new DictDataVo[]{vo1, vo2});
        }
        dictDataVos = dictDataVos.stream().sorted(Comparator.comparing(DictDataVo::getDictSort)).collect(Collectors.toList());
        dictDataVos.forEach(d -> wrapper.orderBy(true, !Objects.equals("desc", d.getDictValue()), new Object[]{d.getDictCode()}));
        return wrapper;
    }
}

