/**
 * 条件规则- 金额~金额
 * @param productBuyNo
 * @param controlRow
 * @return
 */
def func(productBuyNo, controlRow) {
    /**
     * 该阶梯用户设置的满赠数量
     */
    ladderNo = controlRow.controls[0].value;
    /**
     * 返回订单购买金额对满赠金额取余结果，计算规则脚本可依据该结果进行灵活的阶梯计算
     */
    BigDecimal[] temp = new BigDecimal(productBuyNo).divideAndRemainder(new BigDecimal(ladderNo)) ;
    BigDecimal[] result = [temp[0], temp[1], BigDecimal.ONE];
    return result;
};
func(productBuyNo, controlRow);


/**
 * 调试参数
 * {"bizParam":{"productBuyNo":10},"controlRow":{"text":"本单中本品金额购买满","controlKey":"control_key","controls":[{"key":"buyNo","value":10,"label":null,"description":"请输入本品数量","controlType":"input","selectOptions":null},{"key":"buyUnit","value":"base_unit","label":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"base_unit","value":"基本单位"},{"key":"sale_unit","value":"销售单位"}]},{"key":"giftNo","value":55,"label":"，送赠品金额","description":"请输入赠品数量","controlType":"input","selectOptions":null},{"key":"buyUnit","value":"base_unit","label":null,"description":"请选择单位","controlType":"select","selectOptions":[{"key":"base_unit","value":"基本单位"},{"key":"sale_unit","value":"销售单位"}]}]}}
 */



