/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.companyinformation.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.companyinformation.entity.CompanyInformationEntity;
import com.biz.crm.companyinformation.mapper.CompanyInformationMapper;
import com.biz.crm.companyinformation.service.CompanyInformationAreaService;
import com.biz.crm.companyinformation.service.CompanyInformationFileService;
import com.biz.crm.companyinformation.service.CompanyInformationService;
import com.biz.crm.companyinformation.utils.CompanyInformationAreaUtil;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationAreaVo;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationFileVo;
import com.biz.crm.nebular.dms.companyinformation.CompanyInformationVo;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"companyInformationServiceExpandImpl"})
@Service(value="companyInformationService")
public class CompanyInformationServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<CompanyInformationMapper, CompanyInformationEntity>
implements CompanyInformationService {
    @Autowired
    private CompanyInformationMapper companyInformationMapper;
    @Resource
    private CompanyInformationFileService companyInformationFileService;
    @Resource
    private CompanyInformationAreaService companyInformationAreaService;

    @Override
    @Transactional
    public void add(CompanyInformationVo companyInformationVo) {
        ValidateUtils.validate((Object)companyInformationVo.getName(), (String)"\u8bf7\u6307\u5b9a\u8d44\u6599\u540d\u79f0!");
        ValidateUtils.validate((Object)companyInformationVo.getType(), (String)"\u8bf7\u6307\u5b9a\u8d44\u6599\u7c7b\u578b!");
        CompanyInformationEntity entity = new CompanyInformationEntity();
        BeanUtils.copyProperties((Object)companyInformationVo, (Object)((Object)entity));
        this.companyInformationMapper.insert((Object)entity);
        this.companyInformationFileService.replace(entity, companyInformationVo.getFiles());
        this.companyInformationAreaService.replace(entity, CompanyInformationAreaUtil.addAllAreas(companyInformationVo));
    }

    @Override
    @Transactional
    public void edit(CompanyInformationVo companyInformationVo) {
        ValidateUtils.validate((Object)companyInformationVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u8d44\u6599!");
        ValidateUtils.validate((Object)companyInformationVo.getName(), (String)"\u8bf7\u6307\u5b9a\u8d44\u6599\u540d\u79f0!");
        ValidateUtils.validate((Object)companyInformationVo.getType(), (String)"\u8bf7\u6307\u5b9a\u8d44\u6599\u7c7b\u578b!");
        CompanyInformationEntity entity = (CompanyInformationEntity)((Object)this.companyInformationMapper.selectById((Serializable)((Object)companyInformationVo.getId())));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u60a8\u8981\u7f16\u8f91\u7684\u8d44\u6599\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
        BeanUtils.copyProperties((Object)companyInformationVo, (Object)((Object)entity));
        this.companyInformationMapper.updateById((Object)entity);
        this.companyInformationFileService.replace(entity, companyInformationVo.getFiles());
        this.companyInformationAreaService.replace(entity, CompanyInformationAreaUtil.addAllAreas(companyInformationVo));
    }

    @Override
    @CrmDictMethod
    public CompanyInformationVo findById(String id) {
        CompanyInformationVo vo = null;
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u8d44\u6599\uff01");
        CompanyInformationEntity entity = (CompanyInformationEntity)((Object)this.companyInformationMapper.selectById((Serializable)((Object)id)));
        if (null == entity) {
            return vo;
        }
        vo = new CompanyInformationVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        vo.setFiles(this.companyInformationFileService.findByInformationId(vo.getId()));
        Map<String, List<CompanyInformationAreaVo>> areaMap = CompanyInformationAreaUtil.distArea(this.companyInformationAreaService.findByInformationId(id));
        vo.setOrgs(areaMap.get("org"));
        vo.setNonOrgs(areaMap.get("nonOrg"));
        vo.setCustomers(areaMap.get("customer"));
        vo.setNonCustomers(areaMap.get("nonCustomer"));
        return vo;
    }

    @Override
    @CrmDictMethod
    public PageResult<CompanyInformationVo> list(CompanyInformationVo companyInformationVo, String orgCode) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)companyInformationVo.getName()), (Object)"name", (Object)companyInformationVo.getName())).eq(null != companyInformationVo.getType(), (Object)"type", (Object)companyInformationVo.getType())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)companyInformationVo.getPageNum(), (Integer)companyInformationVo.getPageSize());
        List<CompanyInformationVo> list = this.companyInformationMapper.list(page, (QueryWrapper<CompanyInformationVo>)wrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<CompanyInformationVo> listByOrg(CompanyInformationVo companyInformationVo, List<String> orgCodes, String cusCode) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)companyInformationVo.getName()), (Object)"name", (Object)companyInformationVo.getName())).eq(null != companyInformationVo.getType(), (Object)"type", (Object)companyInformationVo.getType())).orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)companyInformationVo.getPageNum(), (Integer)companyInformationVo.getPageSize());
        List<CompanyInformationVo> list = this.companyInformationMapper.listByOrg(page, (QueryWrapper<CompanyInformationVo>)wrapper, orgCodes, cusCode, YesNoEnum.YesNoCodeNumberEnum.NO.getCode(), YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        if (!CollectionUtils.isEmpty(list)) {
            Map<String, List<CompanyInformationFileVo>> fileMap = this.companyInformationFileService.findByInformationIds(list.stream().map(UuidVo::getId).collect(Collectors.toList()));
            for (CompanyInformationVo vo : list) {
                vo.setFiles(fileMap.get(vo.getId()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.companyInformationMapper.deleteBatchIds(ids);
        this.companyInformationFileService.delByInformationIds(ids);
        this.companyInformationAreaService.delByInformationIds(ids);
    }

    @Override
    @Transactional
    public void delByParam(CompanyInformationVo companyInformationVo) {
        if (null == companyInformationVo) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u67e5\u8be2\u6761\u4ef6!");
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)companyInformationVo.getName()), (Object)"name", (Object)companyInformationVo.getName())).eq(null != companyInformationVo.getType(), (Object)"type", (Object)companyInformationVo.getType());
        List entities = this.companyInformationMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)entities)) {
            return;
        }
        List<String> ids = entities.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
        this.companyInformationMapper.delete((Wrapper)wrapper);
        this.companyInformationFileService.delByInformationIds(ids);
        this.companyInformationAreaService.delByInformationIds(ids);
    }
}

