/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditReqVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.nebular.dms.promotion.param.QueryProductPolicyParamVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.promotion.entity.resp.PromotionPolicyPageResp;
import com.biz.crm.promotion.service.PromotionPolicyService;
import com.biz.crm.promotion.service.component.RuleExecuteParam;
import com.biz.crm.promotion.service.component.RuleExecutor;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7ba1\u7406\u7aef-\u4fc3\u9500\u653f\u7b56", tags={"\u7ba1\u7406\u7aef-\u4fc3\u9500\u653f\u7b56"})
@RestController
@RequestMapping(value={"/promotion/policy"})
public class PromotionPolicyController {
    @Resource
    private PromotionPolicyService promotionPolicyService;
    @Resource(name="defaultRuleExecutor")
    private RuleExecutor defaultRuleExecutor;

    @CrmLog
    @ApiOperation(value="\u65b0\u589e\u3001\u4fee\u6539\u653f\u7b56")
    @PostMapping
    public Result addOrUpdate(@RequestBody PromotionPolicyEditReqVo vo) {
        this.promotionPolicyService.addOrUpdate(vo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u67e5\u8be2\u7ed9\u5b9a\u7684\u5ba2\u6237\u5728\u7ed9\u5b9a\u7684\u5546\u54c1\u4e0b\u80fd\u591f\u4eab\u53d7\u7684\u4fc3\u9500\u653f\u7b56")
    @GetMapping(value={"custandproduct"})
    public Result<List<PromotionPolicyInfoDataVo>> loadPromotionPolicyInfoByCustAndProduct(@RequestParam(value="custCode") String custCode, @RequestParam(value="productCode") String productCode) {
        return Result.ok(this.promotionPolicyService.loadPromotionPolicyInfoByCustAndProduct(custCode, productCode));
    }

    @CrmLog
    @ApiOperation(value="\u67e5\u8be2\u7ed9\u5b9a\u7684\u5ba2\u6237\u5728\u7ed9\u5b9a\u7684\u5546\u54c1\u5217\u8868\u4e0b\u80fd\u591f\u4eab\u53d7\u7684\u4fc3\u9500\u653f\u7b56")
    @PostMapping(value={"custandproducts"})
    public Result<Map<String, List<PromotionPolicyInfoVo>>> loadPromotionPolicyInfoByCustAndProducts(@RequestParam(value="custCode") String custCode, @RequestBody List<String> productCodes) {
        return Result.ok(this.promotionPolicyService.loadPromotionPolicyInfoByCustAndProducts(custCode, productCodes));
    }

    @CrmLog
    @ApiOperation(value="\u7ed9\u5b9a\u7684\u5ba2\u6237\u5728\u7ed9\u5b9a\u7684\u5546\u54c1\u5217\u8868\u4e0b\u662f\u5426\u80fd\u4eab\u53d7\u4fc3\u9500\u653f\u7b56")
    @PostMapping(value={"custProductsHasPromotionPolicy"})
    public Result<Map<String, Boolean>> custProductsHasPromotionPolicy(@RequestParam(value="custCode") String custCode, @RequestBody List<String> productCodes) {
        return Result.ok(this.promotionPolicyService.custProductsHasPromotionPolicy(custCode, productCodes));
    }

    @CrmLog
    @ApiOperation(value="\u52a0\u8f7d\u653f\u7b56\u7f16\u8f91\u9875\u9762\u6570\u636e")
    @GetMapping(value={"editinfo"})
    public Result<PromotionPolicyEditVo> loadPolicyEditVo(@RequestParam(value="id", required=false) String id, @RequestParam(value="templateId", required=false) String templateId) {
        return Result.ok((Object)this.promotionPolicyService.loadPolicyEditVo(id, templateId));
    }

    @CrmLog
    @ApiOperation(value="\u5206\u9875\u641c\u7d22")
    @CrmDictMethod
    @PostMapping(value={"page"})
    public Result<PageResult<PromotionPolicyPageResp>> getPageList(@RequestBody PromotionPolicyQueryVo vo) {
        return Result.ok(this.promotionPolicyService.getPageList(vo));
    }

    @CrmLog
    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"del"})
    public Result del(@RequestBody List<String> promotionPolicyIds) {
        this.promotionPolicyService.del(promotionPolicyIds);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"disable"})
    public Result disable(@RequestBody List<String> promotionPolicyIds) {
        this.promotionPolicyService.disable(promotionPolicyIds);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"enable"})
    public Result enable(@RequestBody List<String> promotionPolicyIds) {
        this.promotionPolicyService.enable(promotionPolicyIds);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u52a0\u8f7d\u8ba2\u5355\u4e0b\u6240\u6709\u5546\u54c1\u4eab\u53d7\u7684\u4fc3\u9500\u653f\u7b56\u548c\u653f\u7b56\u89c4\u5219\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"loadPromotionPolicyConfigInfoForOrder"})
    public Result<Map<String, List<PromotionPolicyConfigInfo>>> loadPromotionPolicyConfigInfoForOrder(@RequestBody PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
        return Result.ok(this.promotionPolicyService.loadPromotionPolicyConfigInfoForOrder(configInfoQueryVo));
    }

    @CrmLog
    @ApiOperation(value="\u52a0\u8f7d\u5546\u54c1\u4eab\u53d7\u7684\u4fc3\u9500\u653f\u7b56\u548c\u653f\u7b56\u89c4\u5219\u914d\u7f6e\u4fe1\u606f")
    @PostMapping(value={"loadPromotionPolicyConfigInfoByProductCode"})
    public Result<List<PromotionPolicyConfigInfo>> loadPromotionPolicyConfigInfoByProductCode(@RequestBody QueryProductPolicyParamVo productPolicyParamVo) {
        return Result.ok(this.promotionPolicyService.loadPromotionPolicyConfigInfoByProductCode(productPolicyParamVo));
    }

    @CrmLog
    @ApiOperation(value="\u9ed8\u8ba4\u653f\u7b56\u4e1a\u52a1\u89c4\u5219\u6267\u884c\u5b9e\u73b0")
    @PostMapping(value={"testDefaultRuleExecutor"})
    public Result<CalculateRuleResponse> testDefaultRuleExecutor(@RequestBody RuleExecuteParam shellParam) {
        return Result.ok(this.defaultRuleExecutor.execute(shellParam));
    }

    @CrmLog
    @ApiOperation(value="\u8ba1\u7b97\u7ed9\u5b9a\u65e5\u671f\u751f\u6548\u548c\u5931\u6548\u653f\u7b56\u5f71\u54cd\u5230\u7684\u5ba2\u6237\u5217\u8868")
    @PostMapping(value={"countBeginAndEndAffectedCustoms"})
    public Result<List<String>> countBeginAndEndAffectedCustoms(@RequestParam(required=false) String date) {
        return Result.ok(this.promotionPolicyService.countBeginAndEndAffectedCustoms(date));
    }
}

