/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.repfeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.dms.repfeepool.ListFeeReq;
import com.biz.crm.nebular.dms.repfeepool.ListUsedRes;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolBpmVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolFileVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemDetailLogVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolItemVo;
import com.biz.crm.nebular.dms.repfeepool.RepFeePoolVo;
import com.biz.crm.nebular.dms.repfeepool.RepItemReflushVo;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolBpmUtil;
import com.biz.crm.repfeepool.entity.RepFeePoolBpmEntity;
import com.biz.crm.repfeepool.entity.RepFeePoolItemDetailLogEntity;
import com.biz.crm.repfeepool.mapper.RepFeePoolBpmMapper;
import com.biz.crm.repfeepool.mapper.RepFeePoolItemDetailLogMapper;
import com.biz.crm.repfeepool.service.RepFeePoolBpmService;
import com.biz.crm.repfeepool.service.RepFeePoolFileService;
import com.biz.crm.repfeepool.service.RepFeePoolIItemDetailLogService;
import com.biz.crm.repfeepool.service.RepFeePoolItemService;
import com.biz.crm.repfeepool.service.RepFeePoolService;
import com.biz.crm.repfeepool.utils.RepFeePoolBpmUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolItemDetailLogUtil;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import io.jsonwebtoken.lang.Collections;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="repFeePoolBpmService")
@ConditionalOnMissingBean(name={"repFeePoolBpmServiceImpl"})
public class RepFeePoolBpmServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RepFeePoolBpmMapper, RepFeePoolBpmEntity>
implements RepFeePoolBpmService {
    @Value(value="${dms.approval:false}")
    private boolean isApproval;
    @Resource
    private RepFeePoolBpmMapper repFeePoolBpmMapper;
    @Resource
    private RepFeePoolIItemDetailLogService repFeePoolIItemDetailLogService;
    @Resource
    private RepFeePoolService repFeePoolService;
    @Resource
    private RepFeePoolItemService repFeePoolItemService;
    @Resource
    private RepFeePoolFileService repFeePoolFileService;
    @Resource
    private RepFeePoolItemDetailLogMapper repFeePoolItemDetailLogMapper;

    @Override
    public PageResult<RepFeePoolBpmVo> findPageByConditions(RepFeePoolBpmVo param) {
        Page page;
        List<RepFeePoolBpmVo> pageList;
        if (param == null) {
            return PageResult.builder().count(Long.valueOf(0L)).data((List)Lists.newArrayList()).build();
        }
        if (CollectionUtil.listEmpty((List)param.getBpmStates())) {
            param.setBpmStates((List)Lists.newArrayList((Object[])new String[]{"0", "1", "2", "3", "4"}));
        }
        if (Collections.isEmpty(pageList = this.repFeePoolBpmMapper.findPageByConditions((Page<RepFeePoolBpmVo>)(page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue())), param))) {
            return PageResult.builder().count(Long.valueOf(0L)).data((List)Lists.newArrayList()).build();
        }
        pageList.forEach(vo -> {
            List<RepFeePoolFileVo> files = this.repFeePoolFileService.findByLogCode(vo.getCode());
            vo.setFiles(files);
            vo.setAdjustMethod(Objects.equals(RepFeePoolBpmUtil.ApprovalEnum.WITHOUT_APPROVE.getState(), vo.getBpmState()) ? "\u81ea\u52a8" : "\u624b\u52a8");
            if (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.isType(vo.getAdjustCountType(), 0)) {
                vo.setAdjustCount(vo.getAdjustCount().multiply(BigDecimal.valueOf(-1L)));
                vo.setAdjustFee(vo.getAdjustFee().multiply(BigDecimal.valueOf(-1L)));
            }
        });
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(pageList).build();
    }

    @Override
    @Transactional
    public void approval(String code, Integer bpmState) {
        ValidateUtils.validate((Object)code, (String)"\u5ba1\u6279\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)bpmState, (String)"\u5ba1\u6279\u65f6\uff0c\u5ba1\u6279\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"code", (Object)code);
        RepFeePoolBpmEntity entity = (RepFeePoolBpmEntity)((Object)this.repFeePoolBpmMapper.selectOne((Wrapper)wrapper));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u64cd\u4f5c\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        List<RepFeePoolItemDetailLogVo> logs = this.repFeePoolIItemDetailLogService.findByBpmCode(code);
        RepFeePoolItemVo itemVo = this.repFeePoolItemService.findByCode(entity.getRepFeePoolItemCode());
        List<RepFeePoolFileVo> files = this.repFeePoolFileService.findByLogCode(entity.getCode());
        switch (RepFeePoolBpmUtil.getApprovalEnum(bpmState)) {
            case APPROVING: {
                RepFeePoolVo repFeePoolVo;
                ValidateUtils.isTrue((RepFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState().equals(entity.getBpmState()) || RepFeePoolBpmUtil.ApprovalEnum.REJECT.getState().equals(entity.getBpmState()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u672a\u63d0\u4ea4\u72b6\u6001\u7684\u8bb0\u5f55\u624d\u80fd\u63d0\u4ea4", (Object[])new Object[0]);
                entity.setBpmState(bpmState);
                if (Objects.equals(RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_REDUCE.getCode(), entity.getAdjustCountType())) {
                    entity.setBpmState(RepFeePoolBpmUtil.ApprovalEnum.APPROVING.getState());
                    ValidateUtils.validate((Object)itemVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8d39\u7528\u6c60\u660e\u7ec6\u8bb0\u5f55");
                    repFeePoolVo = new RepFeePoolVo();
                    repFeePoolVo.setCode(itemVo.getRepFeePoolCode());
                    repFeePoolVo.setUniqueDictCode(entity.getUniqueDictCode());
                    repFeePoolVo.setCusCode(entity.getCusCode());
                    repFeePoolVo.setSaleCompanyCode(entity.getSaleCompanyCode());
                    itemVo.setProductCode(entity.getProductCode());
                    itemVo.setAdjustCountType(entity.getAdjustCountType());
                    itemVo.setAdjustFeeType(entity.getAdjustFeeType());
                    itemVo.setAdjustFee(entity.getAdjustFee());
                    itemVo.setAdjustCount(entity.getAdjustCount());
                    itemVo.setAdjustReason(entity.getAdjustReason());
                    itemVo.setResourceCode(entity.getResourceCode());
                    itemVo.setIndexDictCode(entity.getIndexDictCode());
                    itemVo.setRemarks(entity.getRemarks());
                    itemVo.setApproved(true);
                    itemVo.setFiles(files);
                    itemVo.setPrice(entity.getPrice());
                    itemVo.setBpmVo(BeanCopyUtil.copyBen((Object)entity, RepFeePoolBpmVo.class));
                    repFeePoolVo.setRepFeePoolItemVos((List)Lists.newArrayList((Object[])new RepFeePoolItemVo[]{itemVo}));
                    this.repFeePoolService.wrapperAdjust(repFeePoolVo);
                    LambdaUpdateWrapper logEntityQueryWrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)logEntityQueryWrapper.set(RepFeePoolItemDetailLogEntity::getBpmState, (Object)RepFeePoolBpmUtil.ApprovalEnum.PROCESSED.getState())).in(BaseIdEntity::getId, (Collection)logs.stream().map(UuidVo::getId).collect(Collectors.toList()));
                    this.repFeePoolItemDetailLogMapper.update(null, (Wrapper)logEntityQueryWrapper);
                } else {
                    this.updateLogs(logs, entity);
                }
                entity.setCommitTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                break;
            }
            case PROCESSED: {
                ValidateUtils.isTrue((boolean)RepFeePoolBpmUtil.ApprovalEnum.APPROVING.getState().equals(entity.getBpmState()), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u8bb0\u5f55\u624d\u80fd\u5ba1\u6279\u901a\u8fc7", (Object[])new Object[0]);
                entity.setBpmState(bpmState);
                this.updateLogs(logs, entity);
                if (!Objects.equals(RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_ADD.getCode(), entity.getAdjustCountType())) break;
                ValidateUtils.validate((Object)itemVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8d39\u7528\u6c60\u660e\u7ec6\u8bb0\u5f55");
                RepFeePoolVo repFeePoolVo = new RepFeePoolVo();
                repFeePoolVo.setCode(itemVo.getRepFeePoolCode());
                repFeePoolVo.setUniqueDictCode(entity.getUniqueDictCode());
                repFeePoolVo.setCusCode(entity.getCusCode());
                repFeePoolVo.setSaleCompanyCode(entity.getSaleCompanyCode());
                itemVo.setProductCode(entity.getProductCode());
                itemVo.setAdjustCountType(entity.getAdjustCountType());
                itemVo.setAdjustFeeType(entity.getAdjustCountType());
                itemVo.setAdjustFee(entity.getAdjustFee());
                itemVo.setAdjustCount(entity.getAdjustCount());
                itemVo.setAdjustReason(entity.getAdjustReason());
                itemVo.setResourceCode(entity.getResourceCode());
                itemVo.setIndexDictCode(entity.getIndexDictCode());
                itemVo.setRemarks(entity.getRemarks());
                itemVo.setPrice(entity.getPrice());
                itemVo.setApproved(true);
                itemVo.setFiles(files);
                itemVo.setBpmVo(BeanCopyUtil.copyBen((Object)entity, RepFeePoolBpmVo.class));
                repFeePoolVo.setRepFeePoolItemVos((List)Lists.newArrayList((Object[])new RepFeePoolItemVo[]{itemVo}));
                this.repFeePoolService.wrapperAdjust(repFeePoolVo);
                break;
            }
            case REJECT: {
                if (!Objects.equals(RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_REDUCE.getCode(), entity.getAdjustCountType())) {
                    ValidateUtils.isTrue((boolean)RepFeePoolBpmUtil.ApprovalEnum.APPROVING.getState().equals(entity.getBpmState()), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u8bb0\u5f55\u624d\u80fd\u9a73\u56de", (Object[])new Object[0]);
                }
                entity.setBpmState(bpmState);
                LambdaUpdateWrapper logEntityQueryWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)logEntityQueryWrapper.set(RepFeePoolItemDetailLogEntity::getBpmState, (Object)RepFeePoolBpmUtil.ApprovalEnum.WITHOUT_APPROVE.getState())).in(BaseIdEntity::getId, (Collection)logs.stream().map(UuidVo::getId).collect(Collectors.toList()));
                this.repFeePoolItemDetailLogMapper.update(null, (Wrapper)logEntityQueryWrapper);
                this.repFeePoolItemService.reflush(entity.getCusCode(), entity.getSaleCompanyCode(), entity.getProductCode());
                break;
            }
            default: {
                throw new BusinessException("\u5ba1\u6279\u72b6\u6001\u4e0d\u6b63\u786e\uff0c1\uff08\u5ba1\u6279\u4e2d\uff09\uff0c\u53ea\u5141\u8bb8\u4f20\u51652\uff08\u901a\u8fc7\uff09\uff0c3\uff08\u9a73\u56de\uff09");
            }
        }
        UserRedis user = UserUtils.getUser();
        if (user != null && RepFeePoolBpmUtil.getApprovalEnum(bpmState) != RepFeePoolBpmUtil.ApprovalEnum.APPROVING) {
            entity.setBpmAccount(user.getUsername());
            entity.setBpmFullName(user.getRealname());
            entity.setBpmTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        this.repFeePoolBpmMapper.updateById((Object)entity);
        this.repFeePoolItemService.reflush(entity.getCusCode(), entity.getSaleCompanyCode(), entity.getProductCode());
    }

    private void updateLogs(List<RepFeePoolItemDetailLogVo> logs, RepFeePoolBpmEntity entity) {
        LambdaUpdateWrapper logEntityQueryWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)logEntityQueryWrapper.set(RepFeePoolItemDetailLogEntity::getBpmState, (Object)entity.getBpmState())).in(BaseIdEntity::getId, (Collection)logs.stream().map(UuidVo::getId).collect(Collectors.toList()));
        this.repFeePoolItemDetailLogMapper.update(null, (Wrapper)logEntityQueryWrapper);
    }

    @Override
    @Transactional
    public RepFeePoolBpmVo create(RepFeePoolBpmVo vo) {
        RepFeePoolBpmUtil.crateValidate(vo);
        vo.setCode(CodeUtil.generateCode((String)"dms_rep_fee_pool_bpm"));
        FieldHandleUtil.initCreateFields(vo);
        vo.setCreateTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        RepFeePoolBpmEntity entity = BeanCopyUtil.copyBen(vo, RepFeePoolBpmEntity.class);
        if (this.isApproval(vo.getAdjustCountType())) {
            entity.setBpmState(RepFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState());
        } else {
            entity.setBpmState(RepFeePoolBpmUtil.ApprovalEnum.WITHOUT_APPROVE.getState());
        }
        this.repFeePoolBpmMapper.insert((Object)entity);
        if (!CollectionUtil.listEmpty((List)vo.getFiles())) {
            vo.getFiles().forEach(f -> f.setRebateFeePoolDetailLogCode(vo.getCode()));
            this.repFeePoolFileService.createAll(vo.getFiles());
        }
        return BeanCopyUtil.copyBen((Object)entity, RepFeePoolBpmVo.class);
    }

    @Override
    public boolean isApproval(Integer adjustType) {
        if (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_ADD.getCode().equals(adjustType) || RepFeePoolItemDetailLogUtil.AdjustTypeEnum.ADJUST_REDUCE.getCode().equals(adjustType) || RepFeePoolItemDetailLogUtil.AdjustTypeEnum.HAND_ON_ACCOUNT.getCode().equals(adjustType) || RepFeePoolItemDetailLogUtil.AdjustTypeEnum.BEGIN_PERIOD.getCode().equals(adjustType)) {
            return this.isApproval;
        }
        return false;
    }

    @Override
    public boolean isApproval() {
        return this.isApproval;
    }

    @Override
    public RepItemReflushVo sumFeeByPoolCode(String poolItemCode) {
        if (StringUtils.isEmpty((String)poolItemCode)) {
            return new RepItemReflushVo();
        }
        ArrayList<Integer> bpmstates = new ArrayList<Integer>();
        bpmstates.add(RebateFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState());
        bpmstates.add(RebateFeePoolBpmUtil.ApprovalEnum.APPROVING.getState());
        bpmstates.add(RebateFeePoolBpmUtil.ApprovalEnum.REJECT.getState());
        List<RepItemReflushVo> list = this.repFeePoolBpmMapper.sumFeeByPoolCode(poolItemCode, bpmstates);
        if (CollectionUtils.isEmpty(list)) {
            return new RepItemReflushVo();
        }
        RepItemReflushVo reVo = new RepItemReflushVo();
        for (RepItemReflushVo vo : list) {
            if (vo.getBpmState().intValue() == RebateFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState().intValue() || vo.getBpmState().intValue() == RebateFeePoolBpmUtil.ApprovalEnum.REJECT.getState().intValue()) {
                reVo.setToSubmitFee(reVo.getToSubmitFee().add(vo.getFee()));
                reVo.setToSubmitNum(reVo.getToSubmitNum().add(vo.getNum()));
                continue;
            }
            reVo.setToExamineFee(reVo.getToExamineFee().add(vo.getFee()));
            reVo.setToExamineNum(reVo.getToExamineNum().add(vo.getNum()));
            if (!RepFeePoolItemDetailLogUtil.AdjustTypeEnum.isType(vo.getAdjustType(), 0)) continue;
            reVo.setOccupyFee(reVo.getOccupyFee().add(vo.getFee()));
            reVo.setOccupyNum(reVo.getOccupyNum().add(vo.getNum()));
        }
        return reVo;
    }

    @Override
    @CrmDictMethod
    public PageResult<ListUsedRes> listUsed(String cusCode, ListFeeReq listFeeReq) {
        Page page = PageUtil.buildPage((Integer)listFeeReq.getPageNum(), (Integer)listFeeReq.getPageSize());
        List<ListUsedRes> list = this.repFeePoolBpmMapper.listUsed(page, cusCode, listFeeReq, RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getCodeByType(0));
        if (!CollectionUtils.isEmpty(list)) {
            List<String> codes = list.stream().map(vo -> vo.getCode()).collect(Collectors.toList());
            Map<String, List<String>> fileMap = this.repFeePoolFileService.getFileByCodes(codes);
            for (ListUsedRes listUsedRes : list) {
                listUsedRes.setFileUrls(fileMap.get(fileMap.get(listUsedRes.getCode())));
                listUsedRes.setCreateTime(listUsedRes.getHappenDate() + " " + listUsedRes.getCreateTime());
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void update(RepFeePoolBpmVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u4fee\u6539\u64cd\u4f5c\u8bb0\u5f55\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"code", (Object)vo.getCode());
        RepFeePoolBpmEntity entity = (RepFeePoolBpmEntity)((Object)this.repFeePoolBpmMapper.selectOne((Wrapper)wrapper));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u64cd\u4f5c\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        ValidateUtils.isTrue((Objects.equals(entity.getBpmState(), RepFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState()) || Objects.equals(entity.getBpmState(), RepFeePoolBpmUtil.ApprovalEnum.APPROVING.getState()) || Objects.equals(entity.getBpmState(), RepFeePoolBpmUtil.ApprovalEnum.REJECT.getState()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u63d0\u4ea4/\u5ba1\u6279\u4e2d/\u9a73\u56de\u7684\u8bb0\u5f55\u624d\u5141\u8bb8\u7f16\u8f91", (Object[])new Object[0]);
        RepFeePoolItemVo itemVo = this.repFeePoolItemService.findByCode(entity.getRepFeePoolItemCode());
        ValidateUtils.validate((Object)itemVo, (String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u8d27\u8865\u8d39\u7528\u6c60\u660e\u7ec6\u8bb0\u5f55");
        List<RepFeePoolItemDetailLogVo> logs = this.repFeePoolIItemDetailLogService.findByBpmCode(entity.getCode());
        List files = vo.getFiles();
        FieldHandleUtil.initDecimalZero(vo);
        BigDecimal price = entity.getPrice();
        vo.setAdjustFeeType(vo.getAdjustCountType());
        vo.setAdjustFee(vo.getAdjustCount().multiply(price));
        entity.setAdjustCount(vo.getAdjustCount());
        entity.setAdjustFee(vo.getAdjustFee());
        entity.setRemarks(vo.getRemarks());
        switch (RepFeePoolItemDetailLogUtil.AdjustTypeEnum.getEnumByCode(entity.getAdjustCountType())) {
            case HAND_ON_ACCOUNT: 
            case BEGIN_PERIOD: 
            case ADJUST_ADD: {
                ValidateUtils.isTrue((logs.size() == 1 ? 1 : 0) != 0, (String)"\u6570\u636e\u5f02\u5e38\uff0c\u671f\u521d\u3001\u624b\u52a8\u4e0a\u8d26\u3001\u8c03\u589e\u4ea7\u751f\u7684\u6761\u76ee\u65e5\u5fd7\u5e94\u8be5\u6709\u4e14\u4ec5\u6709\u4e00\u6761\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u95ee\u9898", (Object[])new Object[0]);
                RepFeePoolItemDetailLogVo logVo = logs.get(0);
                logVo.setAdjustCount(vo.getAdjustCount());
                logVo.setAdjustFee(vo.getAdjustCount().multiply(price));
                logVo.setBpmState(RepFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState());
                logVo.setRemarks(vo.getRemarks());
                logVo.setFiles(files);
                this.repFeePoolIItemDetailLogService.update(logVo);
                break;
            }
            case ADJUST_REDUCE: {
                List<String> ids = logs.stream().map(UuidVo::getId).collect(Collectors.toList());
                this.repFeePoolIItemDetailLogService.deleteByIds(ids);
                RepFeePoolVo repFeePoolVo = new RepFeePoolVo();
                repFeePoolVo.setCode(itemVo.getRepFeePoolCode());
                repFeePoolVo.setUniqueDictCode(entity.getUniqueDictCode());
                repFeePoolVo.setCusCode(entity.getCusCode());
                repFeePoolVo.setSaleCompanyCode(entity.getSaleCompanyCode());
                itemVo.setProductCode(entity.getProductCode());
                itemVo.setAdjustCountType(entity.getAdjustCountType());
                itemVo.setAdjustFeeType(entity.getAdjustFeeType());
                itemVo.setAdjustFee(entity.getAdjustFee());
                itemVo.setAdjustCount(entity.getAdjustCount());
                itemVo.setAdjustReason(entity.getAdjustReason());
                itemVo.setResourceCode(entity.getResourceCode());
                itemVo.setIndexDictCode(entity.getIndexDictCode());
                itemVo.setRemarks(entity.getRemarks());
                itemVo.setApproved(false);
                itemVo.setFiles(files);
                itemVo.setPrice(entity.getPrice());
                itemVo.setBpmVo(BeanCopyUtil.copyBen((Object)entity, RepFeePoolBpmVo.class));
                repFeePoolVo.setRepFeePoolItemVos((List)Lists.newArrayList((Object[])new RepFeePoolItemVo[]{itemVo}));
                this.repFeePoolService.wrapperAdjust(repFeePoolVo);
                break;
            }
            default: {
                throw new BusinessException("\u7f16\u8f91\u64cd\u4f5c\u8bb0\u5f55\u53ea\u652f\u6301\u4e00\u4e0b\u8c03\u6574\u7c7b\u578b\uff1a1\uff08\u671f\u521d\uff09\u30012\uff08\u624b\u52a8\u4e0a\u8d26\uff09\u300110\uff08\u8c03\u589e\uff09\u300111\uff08\u8c03\u51cf\uff09");
            }
        }
        entity.setBpmState(RepFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState());
        this.repFeePoolBpmMapper.updateById((Object)entity);
        List<RepFeePoolFileVo> dbFiles = this.repFeePoolFileService.findByLogCode(entity.getCode());
        if (!CollectionUtil.listEmpty(dbFiles)) {
            this.repFeePoolFileService.deleteAll(dbFiles);
        }
        if (!CollectionUtil.listEmpty((List)files)) {
            files.forEach(f -> f.setRebateFeePoolDetailLogCode(entity.getCode()));
            this.repFeePoolFileService.createAll(files);
        }
        this.repFeePoolItemService.reflush(entity.getCusCode(), entity.getSaleCompanyCode(), entity.getProductCode());
    }
}

