/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.promotion.service.component.function.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.nebular.dms.promotion.PromotionRuleEditVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.CalculateRuleResponse;
import com.biz.crm.promotion.service.component.function.AbstractCalculateRuleFunction;
import com.biz.crm.promotion.service.component.function.RuleFunction;
import com.biz.crm.promotion.service.component.function.param.CalculateRuleParam;
import com.biz.crm.promotion.service.component.function.param.ConditionRuleParam;
import com.biz.crm.promotion.service.component.function.response.ConditionRuleResponse;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;

@Component(value="calculateLadderLoopGift")
public class CalculateLadderLoopGift
extends AbstractCalculateRuleFunction<CalculateRuleParam, CalculateRuleResponse> {
    @Override
    public CalculateRuleResponse apply(CalculateRuleParam calculateRuleParam) {
        RuleFunction ruleFunction;
        try {
            ruleFunction = (RuleFunction)SpringApplicationContextUtil.getApplicationContext().getBean(calculateRuleParam.getConditionRuleFunctionBeanName(), RuleFunction.class);
        }
        catch (BeansException e) {
            throw new BusinessException("\u4fc3\u9500\u653f\u7b56\u6761\u4ef6\u89c4\u5219[" + calculateRuleParam.getConditionRuleFunctionBeanName() + "]\u8ba1\u7b97\u5931\u8d25, \u672a\u67e5\u627e\u5230\u8be5\u89c4\u5219\u7684\u8ba1\u7b97\u5b9e\u4f8b", (Throwable)e);
        }
        String resultDataType = null;
        String resultDataUnitType = null;
        BigDecimal result = null;
        List<PromotionRuleEditVo.ControlRow> ladderList = calculateRuleParam.getLadderList();
        PromotionRuleEditVo.ControlRow tempLadder = null;
        String msg = new String();
        ConditionRuleParam conditionRuleParam = new ConditionRuleParam();
        ArrayList ladders = Lists.newArrayList();
        for (int i = ladderList.size() - 1; i >= 0; --i) {
            tempLadder = ladderList.get(i);
            conditionRuleParam.setLadder(tempLadder);
            conditionRuleParam.setProductOrderBuy(calculateRuleParam.getProductOrderBuy());
            ConditionRuleResponse conditionRuleResponse = (ConditionRuleResponse)ruleFunction.apply(conditionRuleParam);
            if (conditionRuleResponse.getDivide().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal computeResult = conditionRuleResponse.getGiftValue() == null ? BigDecimal.ZERO : conditionRuleResponse.getGiftValue();
            resultDataType = conditionRuleResponse.getResultDataType();
            resultDataUnitType = conditionRuleResponse.getResultDataUnitType();
            if (calculateRuleParam.getVariable() == null || calculateRuleParam.getVariable().compareTo(computeResult) > -1) {
                msg = msg.concat("\u5339\u914d\u5230\u7684\u9636\u68af\u662f:".concat(tempLadder.getControlKey()));
                ladders.add(tempLadder);
                if (result == null) {
                    result = BigDecimal.ZERO;
                }
                result = result.add(computeResult.multiply(conditionRuleResponse.getDivide()));
                if (calculateRuleParam.getVariable() == null) continue;
                calculateRuleParam.setVariable(calculateRuleParam.getVariable().subtract(computeResult.multiply(conditionRuleResponse.getDivide())));
                continue;
            }
            msg = msg.concat("\u56e0\u4e3a\u653f\u7b56\u4f59\u91cf\u4e0d\u8db3\uff0c\u6240\u4ee5\u8df3\u8fc7\u8be5\u9636\u68af:".concat(tempLadder.getControlKey()).concat("\u9636\u68af\uff0c"));
        }
        CalculateRuleResponse calculateRuleResponse = new CalculateRuleResponse();
        if (null == result) {
            calculateRuleResponse.setNoLadderMatchMsg("\u8d2d\u4e70\u91cf\u8fd8\u6ca1\u6709\u8fbe\u5230\u653f\u7b56\u9636\u68af\u8d77\u9001\u91cf!");
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                calculateRuleResponse.setNoLadderMatchMsg(msg);
            }
            calculateRuleResponse.setLadderUsed((List)Lists.newArrayList());
            return calculateRuleResponse;
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            calculateRuleResponse.setNoLadderMatchMsg(msg);
        }
        calculateRuleResponse.setResultData(result);
        calculateRuleResponse.setResultDataType(resultDataType);
        calculateRuleResponse.setResultDataUnitType(resultDataUnitType);
        calculateRuleResponse.setLadderUsed((List)ladders);
        return calculateRuleResponse;
    }
}

