/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rebatefeepool.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.dms.rebatefeepool.ListFeeReq;
import com.biz.crm.nebular.dms.rebatefeepool.ListUsedRes;
import com.biz.crm.nebular.dms.rebatefeepool.RebateDetailReflushVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolBpmVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolDetailLogVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolFileVo;
import com.biz.crm.nebular.dms.rebatefeepool.RebateFeePoolVo;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolBpmEntity;
import com.biz.crm.rebatefeepool.entity.RebateFeePoolDetailLogEntity;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolBpmMapper;
import com.biz.crm.rebatefeepool.mapper.RebateFeePoolDetailLogMapper;
import com.biz.crm.rebatefeepool.service.RebateFeePoolApprovalService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolBpmService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolDetailLogService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolFileService;
import com.biz.crm.rebatefeepool.service.RebateFeePoolService;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolBpmUtil;
import com.biz.crm.rebatefeepool.utils.RebateFeePoolDetailLogUtil;
import com.biz.crm.repfeepool.utils.RepFeePoolBpmUtil;
import com.biz.crm.util.BeanCopyUtil;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.FieldHandleUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.bizunited.platform.common.vo.UuidVo;
import com.google.common.collect.Lists;
import io.jsonwebtoken.lang.Collections;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="rebateFeePoolBpmService")
@ConditionalOnMissingBean(name={"rebateFeePoolBpmServiceImpl"})
public class RebateFeePoolBpmServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<RebateFeePoolBpmMapper, RebateFeePoolBpmEntity>
implements RebateFeePoolBpmService {
    @Value(value="${dms.approval:false}")
    private boolean isApproval;
    @Resource
    private RebateFeePoolBpmMapper rebateFeePoolBpmMapper;
    @Resource
    private RebateFeePoolDetailLogService rebateFeePoolDetailLogService;
    @Resource
    private RebateFeePoolService rebateFeePoolService;
    @Resource
    private RebateFeePoolFileService rebateFeePoolFileService;
    @Resource
    private RebateFeePoolApprovalService rebateFeePoolApprovalService;
    @Resource
    private RebateFeePoolDetailLogMapper rebateFeePoolDetailLogMapper;

    @Override
    public PageResult<RebateFeePoolBpmVo> findPageByConditions(RebateFeePoolBpmVo param) {
        List<RebateFeePoolBpmVo> pageList;
        if (param == null) {
            return PageResult.builder().count(Long.valueOf(0L)).data((List)Lists.newArrayList()).build();
        }
        Page page = new Page((long)param.getPageNum().intValue(), (long)param.getPageSize().intValue());
        if (CollectionUtil.listEmpty((List)param.getBpmStates())) {
            param.setBpmStates((List)Lists.newArrayList((Object[])new String[]{"0", "1", "2", "3", "4"}));
        }
        if (Collections.isEmpty(pageList = this.rebateFeePoolBpmMapper.findPageByConditions((Page<RebateFeePoolBpmVo>)page, param))) {
            return PageResult.builder().count(Long.valueOf(0L)).data((List)Lists.newArrayList()).build();
        }
        pageList.forEach(vo -> {
            List<RebateFeePoolFileVo> files = this.rebateFeePoolFileService.findByLogCode(vo.getCode());
            vo.setFiles(files);
            vo.setAdjustMethod(Objects.equals(RepFeePoolBpmUtil.ApprovalEnum.WITHOUT_APPROVE.getState(), vo.getBpmState()) ? "\u81ea\u52a8" : "\u624b\u52a8");
            if (RebateFeePoolDetailLogUtil.AdjustTypeEnum.isType(vo.getAdjustType(), 0)) {
                vo.setAdjustFee(vo.getAdjustFee().multiply(BigDecimal.valueOf(-1L)));
            }
        });
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(pageList).build();
    }

    @Override
    @Transactional
    public void approval(String code, Integer bpmState) {
        UserRedis user;
        ValidateUtils.validate((Object)code, (String)"\u5ba1\u6279\u65f6\uff0c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)bpmState, (String)"\u5ba1\u6279\u65f6\uff0c\u5ba1\u6279\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"code", (Object)code);
        RebateFeePoolBpmEntity entity = (RebateFeePoolBpmEntity)((Object)this.rebateFeePoolBpmMapper.selectOne((Wrapper)wrapper));
        ValidateUtils.validate((Object)((Object)entity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u64cd\u4f5c\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        List<RebateFeePoolDetailLogVo> logs = this.rebateFeePoolDetailLogService.findByBpmCode(code);
        ValidateUtils.notEmpty(logs, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6761\u76ee\u65e5\u5fd7\u8bb0\u5f55", (String[])new String[0]);
        RebateFeePoolVo pool = this.rebateFeePoolService.findPoolByCode(entity.getRebateFeePoolCode());
        List<RebateFeePoolFileVo> files = this.rebateFeePoolFileService.findByLogCode(entity.getCode());
        switch (RebateFeePoolBpmUtil.getApprovalEnum(bpmState)) {
            case APPROVING: {
                ValidateUtils.isTrue((RebateFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState().equals(entity.getBpmState()) || RebateFeePoolBpmUtil.ApprovalEnum.REJECT.getState().equals(entity.getBpmState()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u63d0\u4ea4\u72b6\u6001\u7684\u8bb0\u5f55\u624d\u80fd\u63d0\u4ea4", (Object[])new Object[0]);
                entity.setBpmState(bpmState);
                if (Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.ADJUST_REDUCE.getCode(), entity.getAdjustType()) || Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.ADJUST_ADD.getCode(), entity.getAdjustType())) {
                    entity.setBpmState(RebateFeePoolBpmUtil.ApprovalEnum.APPROVING.getState());
                    ValidateUtils.validate((Object)pool, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8d39\u7528\u6c60\u8bb0\u5f55");
                    pool.setAdjustType(entity.getAdjustType());
                    pool.setAdjustFee(entity.getAdjustFee());
                    pool.setAdjustReason(entity.getAdjustReason());
                    pool.setResourceCode(entity.getResourceCode());
                    pool.setIndexDictCode(entity.getIndexDictCode());
                    pool.setRemarks(entity.getRemarks());
                    pool.setApproved(true);
                    pool.setBpmVo(BeanCopyUtil.copyBen((Object)entity, RebateFeePoolBpmVo.class));
                    pool.setFiles(files);
                    this.rebateFeePoolService.wrapperAdjust(pool);
                }
                entity.setCommitTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                this.rebateFeePoolApprovalService.commit(BeanCopyUtil.copyBen((Object)entity, RebateFeePoolBpmVo.class));
                if (!Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.ADJUST_REDUCE.getCode(), entity.getAdjustType())) break;
                LambdaUpdateWrapper logEntityQueryWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)logEntityQueryWrapper.set(RebateFeePoolDetailLogEntity::getBpmState, (Object)RebateFeePoolBpmUtil.ApprovalEnum.PROCESSED.getState())).in(BaseIdEntity::getId, (Collection)logs.stream().map(UuidVo::getId).collect(Collectors.toList()));
                this.rebateFeePoolDetailLogMapper.update(null, (Wrapper)logEntityQueryWrapper);
                break;
            }
            case PROCESSED: {
                ValidateUtils.isTrue((boolean)RebateFeePoolBpmUtil.ApprovalEnum.APPROVING.getState().equals(entity.getBpmState()), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u8bb0\u5f55\u624d\u80fd\u5ba1\u6279\u901a\u8fc7", (Object[])new Object[0]);
                entity.setBpmState(bpmState);
                LambdaUpdateWrapper logEntityQueryWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)logEntityQueryWrapper.set(RebateFeePoolDetailLogEntity::getBpmState, (Object)RebateFeePoolBpmUtil.ApprovalEnum.PROCESSED.getState())).in(BaseIdEntity::getId, (Collection)logs.stream().map(UuidVo::getId).collect(Collectors.toList()));
                this.rebateFeePoolDetailLogMapper.update(null, (Wrapper)logEntityQueryWrapper);
                break;
            }
            case REJECT: {
                if (!Objects.equals(RebateFeePoolDetailLogUtil.AdjustTypeEnum.ADJUST_REDUCE.getCode(), entity.getAdjustType())) {
                    ValidateUtils.isTrue((boolean)RebateFeePoolBpmUtil.ApprovalEnum.APPROVING.getState().equals(entity.getBpmState()), (String)"\u53ea\u6709\u5ba1\u6279\u4e2d\u7684\u8bb0\u5f55\u624d\u80fd\u9a73\u56de", (Object[])new Object[0]);
                }
                entity.setBpmState(bpmState);
                LambdaUpdateWrapper logEntityQueryWrapper1 = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)logEntityQueryWrapper1.set(RebateFeePoolDetailLogEntity::getBpmState, (Object)RepFeePoolBpmUtil.ApprovalEnum.WITHOUT_APPROVE.getState())).in(BaseIdEntity::getId, (Collection)logs.stream().map(UuidVo::getId).collect(Collectors.toList()));
                this.rebateFeePoolDetailLogMapper.update(null, (Wrapper)logEntityQueryWrapper1);
                break;
            }
            default: {
                throw new BusinessException("\u5ba1\u6279\u72b6\u6001\u4e0d\u6b63\u786e\uff0c1\uff08\u5ba1\u6279\u4e2d\uff09\uff0c\u53ea\u5141\u8bb8\u4f20\u51652\uff08\u901a\u8fc7\uff09\uff0c3\uff08\u9a73\u56de\uff09");
            }
        }
        if ((user = UserUtils.getUser()) != null && RebateFeePoolBpmUtil.getApprovalEnum(bpmState) != RebateFeePoolBpmUtil.ApprovalEnum.APPROVING) {
            entity.setBpmAccount(user.getUsername());
            entity.setBpmFullName(user.getRealname());
            entity.setBpmTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        this.rebateFeePoolBpmMapper.updateById((Object)entity);
        this.rebateFeePoolService.reflush(entity.getCusCode(), entity.getSaleCompanyCode());
    }

    @Override
    @Transactional
    public RebateFeePoolBpmVo create(RebateFeePoolBpmVo vo) {
        RebateFeePoolBpmUtil.crateValidate(vo);
        vo.setCode(CodeUtil.generateCode((String)"dms_rebate_fee_pool_bpm"));
        FieldHandleUtil.initCreateFields(vo);
        vo.setCreateTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (this.isApproval(vo.getAdjustType())) {
            vo.setBpmState(RebateFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState());
        } else {
            vo.setBpmState(RepFeePoolBpmUtil.ApprovalEnum.WITHOUT_APPROVE.getState());
        }
        RebateFeePoolBpmEntity entity = BeanCopyUtil.copyBen(vo, RebateFeePoolBpmEntity.class);
        this.rebateFeePoolBpmMapper.insert((Object)entity);
        if (!CollectionUtil.listEmpty((List)vo.getFiles())) {
            vo.getFiles().forEach(f -> f.setRebateFeePoolDetailLogCode(vo.getCode()));
            this.rebateFeePoolFileService.createAll(vo.getFiles());
        }
        return BeanCopyUtil.copyBen((Object)entity, RebateFeePoolBpmVo.class);
    }

    @Override
    public boolean isApproval(Integer adjustType) {
        if (RebateFeePoolDetailLogUtil.AdjustTypeEnum.ADJUST_ADD.getCode().equals(adjustType) || RebateFeePoolDetailLogUtil.AdjustTypeEnum.ADJUST_REDUCE.getCode().equals(adjustType) || RebateFeePoolDetailLogUtil.AdjustTypeEnum.HAND_ON_ACCOUNT.getCode().equals(adjustType) || RebateFeePoolDetailLogUtil.AdjustTypeEnum.BEGIN_PERIOD.getCode().equals(adjustType)) {
            return this.isApproval;
        }
        return false;
    }

    @Override
    public RebateDetailReflushVo sumFeeByPoolCode(String poolCode) {
        if (StringUtils.isEmpty((String)poolCode)) {
            return new RebateDetailReflushVo();
        }
        ArrayList<Integer> bpmstates = new ArrayList<Integer>();
        bpmstates.add(RebateFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState());
        bpmstates.add(RebateFeePoolBpmUtil.ApprovalEnum.APPROVING.getState());
        List<RebateDetailReflushVo> list = this.rebateFeePoolBpmMapper.sumFeeByPoolCode(poolCode, bpmstates);
        if (CollectionUtils.isEmpty(list)) {
            return new RebateDetailReflushVo();
        }
        RebateDetailReflushVo reVo = new RebateDetailReflushVo();
        for (RebateDetailReflushVo vo : list) {
            if (vo.getBpmState().intValue() == RebateFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState().intValue()) {
                reVo.setToSubmitFee(reVo.getToSubmitFee().add(vo.getFee()));
                continue;
            }
            reVo.setToExamineFee(reVo.getToExamineFee().add(vo.getFee()));
            if (!RebateFeePoolDetailLogUtil.AdjustTypeEnum.isType(vo.getAdjustType(), 0)) continue;
            reVo.setOccupyFee(reVo.getOccupyFee().add(vo.getFee()));
        }
        return reVo;
    }

    @Override
    @CrmDictMethod
    public PageResult<ListUsedRes> listUsed(String cusCode, ListFeeReq listFeeReq) {
        Page page = PageUtil.buildPage((Integer)listFeeReq.getPageNum(), (Integer)listFeeReq.getPageSize());
        List<ListUsedRes> list = this.rebateFeePoolBpmMapper.listUsed(page, cusCode, listFeeReq, RebateFeePoolDetailLogUtil.AdjustTypeEnum.getCodeByType(0));
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(list)) {
            List<String> codes = list.stream().map(vo -> vo.getCode()).collect(Collectors.toList());
            Map<String, List<String>> fileMap = this.rebateFeePoolFileService.getFileByCodes(codes);
            for (ListUsedRes listUsedRes : list) {
                listUsedRes.setFileUrls(fileMap.get(fileMap.get(listUsedRes.getCode())));
                listUsedRes.setCreateTime(listUsedRes.getHappenDate() + " " + listUsedRes.getCreateTime());
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional
    public void update(RebateFeePoolBpmVo vo) {
        ValidateUtils.validate((Object)vo, (String)"\u4fee\u6539\u64cd\u4f5c\u8bb0\u5f55\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        RebateFeePoolBpmVo dbVo = this.finByCode(vo.getCode());
        ValidateUtils.validate((Object)dbVo, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u64cd\u4f5c\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        ValidateUtils.isTrue((Objects.equals(dbVo.getBpmState(), RebateFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState()) || Objects.equals(dbVo.getBpmState(), RebateFeePoolBpmUtil.ApprovalEnum.APPROVING.getState()) || Objects.equals(dbVo.getBpmState(), RebateFeePoolBpmUtil.ApprovalEnum.REJECT.getState()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u63d0\u4ea4\u5ba1\u6279\u4e2d\u548c\u9a73\u56de\u7684\u8bb0\u5f55\u624d\u5141\u8bb8\u7f16\u8f91", (Object[])new Object[0]);
        ArrayList logs = this.rebateFeePoolDetailLogService.findByBpmCode(dbVo.getCode());
        if (CollectionUtil.listEmpty(logs)) {
            logs = Lists.newArrayList();
        }
        RebateFeePoolVo pool = this.rebateFeePoolService.findPoolByCode(dbVo.getRebateFeePoolCode());
        ValidateUtils.validate((Object)pool, (String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8d39\u7528\u6c60\u8bb0\u5f55\u3010%s\u3011", (Object[])new Object[]{dbVo.getRebateFeePoolCode()});
        List files = vo.getFiles();
        dbVo.setAdjustFee(vo.getAdjustFee());
        dbVo.setRemarks(vo.getRemarks());
        switch (RebateFeePoolDetailLogUtil.AdjustTypeEnum.getEnumByCode(dbVo.getAdjustType())) {
            case HAND_ON_ACCOUNT: 
            case BEGIN_PERIOD: 
            case ADJUST_ADD: {
                ValidateUtils.isTrue((logs.size() == 1 ? 1 : 0) != 0, (String)"\u6570\u636e\u5f02\u5e38\uff0c\u671f\u521d\u3001\u624b\u52a8\u4e0a\u8d26\u3001\u8c03\u589e\u4ea7\u751f\u7684\u6761\u76ee\u65e5\u5fd7\u5e94\u8be5\u6709\u4e14\u4ec5\u6709\u4e00\u6761\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u95ee\u9898", (Object[])new Object[0]);
                RebateFeePoolDetailLogVo logVo = (RebateFeePoolDetailLogVo)logs.get(0);
                logVo.setAdjustFee(vo.getAdjustFee());
                logVo.setBpmState(RebateFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState());
                logVo.setRemarks(vo.getRemarks());
                logVo.setFiles(files);
                this.rebateFeePoolDetailLogService.update(logVo);
                break;
            }
            case ADJUST_REDUCE: {
                List<String> ids = logs.stream().map(UuidVo::getId).collect(Collectors.toList());
                this.rebateFeePoolDetailLogService.deleteByIds(ids);
                pool.setAdjustType(dbVo.getAdjustType());
                pool.setAdjustFee(dbVo.getAdjustFee());
                pool.setAdjustReason(dbVo.getAdjustReason());
                pool.setResourceCode(dbVo.getResourceCode());
                pool.setIndexDictCode(dbVo.getIndexDictCode());
                pool.setRemarks(dbVo.getRemarks());
                pool.setApproved(false);
                pool.setBpmVo(dbVo);
                pool.setFiles(files);
                this.rebateFeePoolService.wrapperAdjust(pool);
                break;
            }
            default: {
                throw new BusinessException("\u7f16\u8f91\u64cd\u4f5c\u8bb0\u5f55\u53ea\u652f\u6301\u4e00\u4e0b\u8c03\u6574\u7c7b\u578b\uff1a1\uff08\u671f\u521d\uff09\u30012\uff08\u624b\u52a8\u4e0a\u8d26\uff09\u300110\uff08\u8c03\u589e\uff09\u300111\uff08\u8c03\u51cf\uff09");
            }
        }
        dbVo.setBpmState(RebateFeePoolBpmUtil.ApprovalEnum.WAITE_COMMIT.getState());
        this.rebateFeePoolBpmMapper.updateById((Object)BeanCopyUtil.copyBen(dbVo, RebateFeePoolBpmEntity.class));
        List<RebateFeePoolFileVo> oldFiles = this.rebateFeePoolFileService.findByLogCode(dbVo.getCode());
        if (!CollectionUtil.listEmpty(oldFiles)) {
            this.rebateFeePoolFileService.deleteAll(oldFiles);
        }
        if (!CollectionUtil.listEmpty((List)files)) {
            files.forEach(f -> f.setRebateFeePoolDetailLogCode(dbVo.getCode()));
            this.rebateFeePoolFileService.createAll(files);
        }
        this.rebateFeePoolService.reflush(dbVo.getCusCode(), dbVo.getSaleCompanyCode());
    }

    @Override
    public RebateFeePoolBpmVo finByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"code", (Object)code);
        RebateFeePoolBpmEntity entity = (RebateFeePoolBpmEntity)((Object)this.rebateFeePoolBpmMapper.selectOne((Wrapper)wrapper));
        if (entity == null) {
            return null;
        }
        return BeanCopyUtil.copyBen((Object)entity, RebateFeePoolBpmVo.class);
    }
}

