/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.contract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.contract.ContractUtil;
import com.biz.crm.contract.entity.ContractEntity;
import com.biz.crm.contract.entity.ContractSalesAreaEntity;
import com.biz.crm.contract.mapper.ContractSalesAreaMapper;
import com.biz.crm.contract.service.ContractSalesAreaService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.contract.ContractSalesAreaVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"contractSalesAreaServiceExpandImpl"})
@Service(value="contractSalesAreaService")
public class ContractSalesAreaServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<ContractSalesAreaMapper, ContractSalesAreaEntity>
implements ContractSalesAreaService {
    @Resource
    private ContractSalesAreaMapper contractSalesAreaMapper;

    @Override
    @Transactional
    public void replace(final ContractEntity contractEntity, List<ContractSalesAreaVo> salesAreas, List<ContractSalesAreaVo> salesAreasNoContain) {
        if (CollectionUtils.isEmpty(salesAreas)) {
            salesAreas = new ArrayList<ContractSalesAreaVo>();
        }
        if (CollectionUtils.isEmpty(salesAreasNoContain)) {
            salesAreasNoContain = new ArrayList<ContractSalesAreaVo>();
        }
        salesAreas.addAll(salesAreasNoContain);
        if (CollectionUtils.isEmpty(salesAreas)) {
            return;
        }
        ContractUtil.checkRepeat(salesAreas);
        this.removeByMap(new HashMap<String, Object>(){
            {
                this.put("contract_id", contractEntity.getId());
            }
        });
        ArrayList<ContractSalesAreaEntity> entities = new ArrayList<ContractSalesAreaEntity>(salesAreas.size());
        for (ContractSalesAreaVo vo : salesAreas) {
            ContractSalesAreaEntity entity = new ContractSalesAreaEntity();
            BeanUtils.copyProperties((Object)vo, (Object)((Object)entity));
            entity.setContractId(contractEntity.getId());
            entities.add(entity);
        }
        this.saveBatch(entities);
    }

    @Override
    public Map<String, List<ContractSalesAreaVo>> findByContractId(String contractId) {
        HashMap<String, List<ContractSalesAreaVo>> reMap = new HashMap<String, List<ContractSalesAreaVo>>();
        ArrayList<ContractSalesAreaVo> containList = new ArrayList<ContractSalesAreaVo>();
        ArrayList<ContractSalesAreaVo> noContainList = new ArrayList<ContractSalesAreaVo>();
        reMap.put("contain", containList);
        reMap.put("noContain", noContainList);
        if (StringUtils.isEmpty((Object)contractId)) {
            return reMap;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"contract_id", (Object)contractId);
        List salesAreaEntities = this.contractSalesAreaMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)salesAreaEntities)) {
            return reMap;
        }
        for (ContractSalesAreaEntity entity : salesAreaEntities) {
            ContractSalesAreaVo salesAreaVo = new ContractSalesAreaVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)salesAreaVo);
            if (null != entity.getContainFlag() && entity.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()) {
                containList.add(salesAreaVo);
                continue;
            }
            noContainList.add(salesAreaVo);
        }
        return reMap;
    }

    @Override
    @Transactional
    public void delByContractIds(List<String> contractIds) {
        if (CollectionUtils.isEmpty(contractIds)) {
            throw new BusinessException("\u5408\u540cid\u4e3a\u7a7a");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"contract_id", contractIds);
        this.contractSalesAreaMapper.delete((Wrapper)wrapper);
    }
}

