/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.utils;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.dms.notice.NoticeAreaVo;
import com.biz.crm.nebular.dms.notice.NoticeVo;
import com.biz.crm.notice.entity.NoticeAreaEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class NoticeAreaUtil {
    public static List<NoticeAreaEntity> judegeOffsetFlag(List<NoticeAreaEntity> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return new ArrayList<NoticeAreaEntity>();
        }
        List containEntities = entities.stream().filter(entitiy -> entitiy.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()).collect(Collectors.toList());
        List<NoticeAreaEntity> nonContainEntities = entities.stream().filter(entitiy -> entitiy.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()).collect(Collectors.toList());
        for (NoticeAreaEntity entity : containEntities) {
            entity.setOffsetFlag(YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
            if (!NoticeAreaUtil.judegeFromNonContain(nonContainEntities, entity)) continue;
            entity.setOffsetFlag(YesNoEnum.YesNoCodeNumberEnum.YES.getCode());
        }
        for (NoticeAreaEntity entity : nonContainEntities) {
            entity.setOffsetFlag(YesNoEnum.YesNoCodeNumberEnum.NO.getCode());
        }
        ArrayList<NoticeAreaEntity> reList = new ArrayList<NoticeAreaEntity>(entities.size());
        reList.addAll(containEntities);
        reList.addAll(nonContainEntities);
        return reList;
    }

    public static boolean judegeFromNonContain(List<NoticeAreaEntity> nonContainEntities, NoticeAreaEntity entity) {
        if (CollectionUtils.isEmpty(nonContainEntities)) {
            return false;
        }
        for (NoticeAreaEntity noEntity : nonContainEntities) {
            if (!StringUtils.isEmpty((Object)noEntity.getOrgCode()) && !StringUtils.isEmpty((Object)entity.getOrgCode()) && noEntity.getOrgCode().equals(entity.getOrgCode())) {
                return true;
            }
            if (StringUtils.isEmpty((Object)noEntity.getCusCode()) || StringUtils.isEmpty((Object)entity.getCusCode()) || !noEntity.getCusCode().equals(entity.getCusCode())) continue;
            return true;
        }
        return false;
    }

    public static List<NoticeAreaVo> addAllAreas(NoticeVo noticeVo) {
        ArrayList<NoticeAreaVo> areaVos = new ArrayList<NoticeAreaVo>();
        if (!CollectionUtils.isEmpty((Collection)noticeVo.getOrgs())) {
            areaVos.addAll(noticeVo.getOrgs());
        }
        if (!CollectionUtils.isEmpty((Collection)noticeVo.getNonOrgs())) {
            areaVos.addAll(noticeVo.getNonOrgs());
        }
        if (!CollectionUtils.isEmpty((Collection)noticeVo.getCustomers())) {
            areaVos.addAll(noticeVo.getCustomers());
        }
        if (!CollectionUtils.isEmpty((Collection)noticeVo.getNonCustomers())) {
            areaVos.addAll(noticeVo.getNonCustomers());
        }
        return areaVos;
    }

    public static Map<String, List<NoticeAreaVo>> distArea(List<NoticeAreaVo> areaVos) {
        HashMap<String, List<NoticeAreaVo>> areaMap = new HashMap<String, List<NoticeAreaVo>>();
        ArrayList blankList = new ArrayList();
        areaMap.put("org", blankList);
        areaMap.put("nonOrg", blankList);
        areaMap.put("customer", blankList);
        areaMap.put("nonCustomer", blankList);
        if (CollectionUtils.isEmpty(areaVos)) {
            return areaMap;
        }
        List org = areaVos.stream().filter(areaVo -> !StringUtils.isEmpty((Object)areaVo.getOrgCode()) && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()).collect(Collectors.toList());
        List nonOrg = areaVos.stream().filter(areaVo -> !StringUtils.isEmpty((Object)areaVo.getOrgCode()) && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()).collect(Collectors.toList());
        List customer = areaVos.stream().filter(areaVo -> !StringUtils.isEmpty((Object)areaVo.getCusCode()) && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.YES.getCode().intValue()).collect(Collectors.toList());
        List nonCustomer = areaVos.stream().filter(areaVo -> !StringUtils.isEmpty((Object)areaVo.getCusCode()) && areaVo.getContainFlag().intValue() == YesNoEnum.YesNoCodeNumberEnum.NO.getCode().intValue()).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(org)) {
            areaMap.put("org", org);
        }
        if (!CollectionUtils.isEmpty(nonOrg)) {
            areaMap.put("nonOrg", nonOrg);
        }
        if (!CollectionUtils.isEmpty(customer)) {
            areaMap.put("customer", customer);
        }
        if (!CollectionUtils.isEmpty(nonCustomer)) {
            areaMap.put("nonCustomer", nonCustomer);
        }
        return areaMap;
    }
}

