/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.orderfeerate.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.eunm.dms.OrderFeeRateEunm;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToCashVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepAndCashVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepProductVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateCalToRepVo;
import com.biz.crm.nebular.dms.orderfeerate.OrderFeeRateVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.orderfeerate.entity.OrderFeeRateEntity;
import com.biz.crm.orderfeerate.mapper.OrderFeeRateMapper;
import com.biz.crm.orderfeerate.service.OrderFeeRateService;
import com.biz.crm.orderfeerate.utils.OrderFeeRateUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ValidateUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@ConditionalOnMissingBean(name={"orderFeeRateServiceExpandImpl"})
@Service(value="orderFeeRateService")
public class OrderFeeRateServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<OrderFeeRateMapper, OrderFeeRateEntity>
implements OrderFeeRateService {
    @Autowired
    private OrderFeeRateMapper orderFeeRateMapper;
    @Resource
    private OrderFeeRateUtil orderFeeRateUtil;

    @Override
    public void add(OrderFeeRateVo orderFeeRateVo) {
        this.orderFeeRateUtil.validate(orderFeeRateVo);
        String useTotal = DictUtil.dictValue((String)"order_fee_rate_pattern", (String)"useTotal");
        OrderFeeRateUtil.validatePattern(orderFeeRateVo, useTotal);
        QueryWrapper wrapper = Wrappers.query();
        if (useTotal.equals(YesNoEnum.yesNoEnum.YES.getValue())) {
            wrapper.in((Object)"fee_type", (Collection)OrderFeeRateEunm.feeTypeEunm.getReTotalCodes());
        } else {
            wrapper.eq((Object)"fee_type", (Object)OrderFeeRateEunm.feeTypeEunm.TOTAL.getCode());
        }
        Integer count = this.orderFeeRateMapper.selectCount((Wrapper)wrapper);
        if (null != count && count > 0) {
            throw new BusinessException("\u5df2\u5b58\u5728\u975e\u8be5\u8d39\u7528\u6c60\u7c7b\u578b\u7684\u8bb0\u5f55\uff0c\u6b32\u6dfb\u52a0\u8be5\u8d39\u7528\u6c60\u7c7b\u578b\uff0c\u8bf7\u5148\u5220\u9664\u6240\u6709\u975e\u8be5\u8d39\u7528\u6c60\u7c7b\u578b\u7684\u8bb0\u5f55\uff01");
        }
        OrderFeeRateEntity entity = new OrderFeeRateEntity();
        BeanUtils.copyProperties((Object)orderFeeRateVo, (Object)((Object)entity));
        String onlyKey = this.orderFeeRateUtil.packageOnlyKey(entity);
        QueryWrapper repeatWrapper = Wrappers.query();
        repeatWrapper.eq((Object)"only_key", (Object)onlyKey);
        Integer repeatCount = this.orderFeeRateMapper.selectCount((Wrapper)repeatWrapper);
        if (null != repeatCount && repeatCount > 0) {
            throw new BusinessException("\u8be5\u7ef4\u5ea6\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setOnlyKey(onlyKey);
        this.orderFeeRateMapper.insert((Object)entity);
    }

    @Override
    public void edit(OrderFeeRateVo orderFeeRateVo) {
        if (StringUtils.isEmpty((CharSequence)orderFeeRateVo.getId())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8981\u4fee\u6539\u7684\u8bb0\u5f55\uff01");
        }
        OrderFeeRateEntity entity = (OrderFeeRateEntity)((Object)this.orderFeeRateMapper.selectById((Serializable)((Object)orderFeeRateVo.getId())));
        if (null == entity) {
            throw new BusinessException("\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728\uff01");
        }
        this.orderFeeRateUtil.validate(orderFeeRateVo);
        String useTotal = DictUtil.dictValue((String)"order_fee_rate_pattern", (String)"useTotal");
        OrderFeeRateUtil.validatePattern(orderFeeRateVo, useTotal);
        QueryWrapper wrapper = Wrappers.query();
        if (useTotal.equals(YesNoEnum.yesNoEnum.YES.getValue())) {
            wrapper.in((Object)"fee_type", (Collection)OrderFeeRateEunm.feeTypeEunm.getReTotalCodes());
        } else {
            wrapper.eq((Object)"fee_type", (Object)OrderFeeRateEunm.feeTypeEunm.TOTAL.getCode());
        }
        Integer count = this.orderFeeRateMapper.selectCount((Wrapper)wrapper);
        if (null != count && count > 0) {
            throw new BusinessException("\u5df2\u5b58\u5728\u975e\u8be5\u8d39\u7528\u6c60\u7c7b\u578b\u7684\u8bb0\u5f55\uff0c\u6b32\u6dfb\u52a0\u8be5\u8d39\u7528\u6c60\u7c7b\u578b\uff0c\u8bf7\u5148\u5220\u9664\u6240\u6709\u975e\u8be5\u8d39\u7528\u6c60\u7c7b\u578b\u7684\u8bb0\u5f55\uff01");
        }
        BeanUtils.copyProperties((Object)orderFeeRateVo, (Object)((Object)entity));
        String onlyKey = this.orderFeeRateUtil.packageOnlyKey(entity);
        QueryWrapper repeatWrapper = Wrappers.query();
        repeatWrapper.eq((Object)"only_key", (Object)onlyKey);
        repeatWrapper.ne((Object)"id", (Object)entity.getId());
        Integer repeatCount = this.orderFeeRateMapper.selectCount((Wrapper)repeatWrapper);
        if (null != repeatCount && repeatCount > 0) {
            throw new BusinessException("\u8be5\u7ef4\u5ea6\u8bb0\u5f55\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        BeanUtils.copyProperties((Object)orderFeeRateVo, (Object)((Object)entity));
        entity.setOnlyKey(onlyKey);
        this.orderFeeRateMapper.updateById((Object)entity);
    }

    @Override
    public OrderFeeRateVo findById(String id) {
        ValidateUtils.validate((Object)id, (String)"\u8bf7\u6307\u5b9a\u9700\u8981\u67e5\u8be2\u7684\u8bb0\u5f55\uff01");
        OrderFeeRateEntity entity = (OrderFeeRateEntity)((Object)this.orderFeeRateMapper.selectById((Serializable)((Object)id)));
        if (null == entity) {
            return null;
        }
        OrderFeeRateVo vo = new OrderFeeRateVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        return vo;
    }

    @Override
    public PageResult<OrderFeeRateVo> list(OrderFeeRateVo orderFeeRateVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((CharSequence)orderFeeRateVo.getProductName()), (Object)"product_name", (Object)orderFeeRateVo.getProductName())).eq(!StringUtils.isEmpty((CharSequence)orderFeeRateVo.getProductCode()), (Object)"product_code", (Object)orderFeeRateVo.getProductCode())).like(!StringUtils.isEmpty((CharSequence)orderFeeRateVo.getProductLevelName()), (Object)"product_level_name", (Object)orderFeeRateVo.getProductLevelName())).eq(!StringUtils.isEmpty((CharSequence)orderFeeRateVo.getProductLevelCode()), (Object)"product_level_code", (Object)orderFeeRateVo.getProductLevelCode())).like(!StringUtils.isEmpty((CharSequence)orderFeeRateVo.getOrgName()), (Object)"org_name", (Object)orderFeeRateVo.getOrgName())).eq(!StringUtils.isEmpty((CharSequence)orderFeeRateVo.getOrgCode()), (Object)"org_code", (Object)orderFeeRateVo.getOrgCode())).like(!StringUtils.isEmpty((CharSequence)orderFeeRateVo.getCusName()), (Object)"cus_name", (Object)orderFeeRateVo.getCusName())).eq(!StringUtils.isEmpty((CharSequence)orderFeeRateVo.getCusCode()), (Object)"cus_code", (Object)orderFeeRateVo.getCusCode())).eq(!StringUtils.isEmpty((CharSequence)orderFeeRateVo.getDemension()), (Object)"demension", (Object)orderFeeRateVo.getDemension())).eq(!StringUtils.isEmpty((CharSequence)orderFeeRateVo.getEnableStatus()), (Object)"enable_status", (Object)orderFeeRateVo.getEnableStatus());
        wrapper.orderByDesc((Object[])new String[]{"create_date", "create_date_second"});
        Page page = PageUtil.buildPage((Integer)orderFeeRateVo.getPageNum(), (Integer)orderFeeRateVo.getPageSize());
        ArrayList list = this.orderFeeRateMapper.list(page, (QueryWrapper<OrderFeeRateVo>)wrapper);
        list = CollectionUtils.isEmpty(list) ? new ArrayList() : list;
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void delByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.orderFeeRateMapper.deleteBatchIds(ids);
    }

    @Override
    public void updateEnable(List<String> ids, CrmEnableStatusEnum crmEnableStatusEnum) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u8981\u4fee\u6539\u7684\u8bb0\u5f55\uff01");
        }
        OrderFeeRateEntity entity = new OrderFeeRateEntity();
        entity.setEnableStatus(crmEnableStatusEnum.getCode());
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().in((Object)"id", ids);
        this.update((Object)entity, (Wrapper)wrapper);
    }

    @Override
    public BigDecimal calToCash(OrderFeeRateCalToCashVo vo) {
        BigDecimal reBigdecimal = null;
        ValidateUtils.validate((Object)vo.getCusCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getOrgCode(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getOrderMoney(), (String)"\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a");
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().in((Object)"demension", (Collection)OrderFeeRateEunm.demension.getCashDemensionCodes())).eq((Object)"fee_type", (Object)OrderFeeRateEunm.feeTypeEunm.CASH.getCode());
        queryWrapper.and(wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"cus_code", (Object)vo.getCusCode())).or()).eq((Object)"org_code", (Object)vo.getOrgCode());
        });
        List rates = this.orderFeeRateMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)rates)) {
            return reBigdecimal;
        }
        Map<String, OrderFeeRateEntity> entityMap = rates.stream().collect(Collectors.toMap(OrderFeeRateEntity::getDemension, a -> a, (k1, k2) -> k1));
        List dictDataVos = DictUtil.list((String)"order_fee_rate_demension");
        dictDataVos = dictDataVos.stream().sorted(Comparator.comparing(DictDataVo::getDictSort)).collect(Collectors.toList());
        for (DictDataVo dictDataVo : dictDataVos) {
            OrderFeeRateEntity entity = entityMap.get(dictDataVo.getDictCode());
            if (null == entity) continue;
            reBigdecimal = vo.getOrderMoney().multiply(entity.getRate()).divide(new BigDecimal(100), 6, 4);
            return reBigdecimal;
        }
        return reBigdecimal;
    }

    @Override
    public Map<String, BigDecimal> calToRep(OrderFeeRateCalToRepVo vo) {
        HashMap<String, BigDecimal> reMap = new HashMap<String, BigDecimal>();
        if (CollectionUtils.isEmpty((Collection)vo.getProducts())) {
            return reMap;
        }
        OrderFeeRateUtil.validateForCalToRep(vo);
        QueryWrapper queryWrapper = (QueryWrapper)Wrappers.query().eq((Object)"fee_type", (Object)OrderFeeRateEunm.feeTypeEunm.REP.getCode());
        queryWrapper.and(wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"cus_code", (Object)vo.getCusCode())).or()).eq((Object)"org_code", (Object)vo.getOrgCode())).or(wrapper1 -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)wrapper1.eq((Object)"cus_code", (Object)"")).and(wrapper2 -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)wrapper2.eq((Object)"org_code", (Object)"");
                });
            });
        });
        List rates = this.orderFeeRateMapper.selectList((Wrapper)queryWrapper);
        List dictDataVos = DictUtil.list((String)"order_fee_rate_demension");
        dictDataVos = dictDataVos.stream().sorted(Comparator.comparing(DictDataVo::getDictSort)).collect(Collectors.toList());
        for (OrderFeeRateCalToRepProductVo product : vo.getProducts()) {
            BigDecimal maxFee = null;
            reMap.put(product.getProductCode(), maxFee);
            List<OrderFeeRateEntity> rateEntityList = OrderFeeRateUtil.filterRate(rates, product);
            if (CollectionUtils.isEmpty(rateEntityList)) continue;
            Map<String, OrderFeeRateEntity> entityMap = rateEntityList.stream().collect(Collectors.toMap(OrderFeeRateEntity::getDemension, a -> a, (k1, k2) -> k1));
            for (DictDataVo dictDataVo : dictDataVos) {
                OrderFeeRateEntity entity = entityMap.get(dictDataVo.getDictCode());
                if (null == entity) continue;
                maxFee = vo.getOrderMoney().multiply(entity.getRate()).divide(new BigDecimal(100), 2, 4);
            }
            reMap.put(product.getProductCode(), maxFee);
        }
        return reMap;
    }

    @Override
    public BigDecimal calToRepAndCash(OrderFeeRateCalToRepAndCashVo vo) {
        BigDecimal reBigdecimal = null;
        ValidateUtils.validate((Object)vo.getCusCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
        ValidateUtils.validate((Object)vo.getOrgCode(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getOrderMoney(), (String)"\u8ba2\u5355\u91d1\u989d\u4e3a\u7a7a");
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().in((Object)"demension", (Collection)OrderFeeRateEunm.demension.getCashAndRepDemensionCodes())).eq((Object)"fee_type", (Object)OrderFeeRateEunm.feeTypeEunm.TOTAL.getCode());
        queryWrapper.and(wrapper -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"cus_code", (Object)vo.getCusCode())).or()).eq((Object)"org_code", (Object)vo.getOrgCode());
        });
        List rates = this.orderFeeRateMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)rates)) {
            return reBigdecimal;
        }
        Map<String, OrderFeeRateEntity> entityMap = rates.stream().collect(Collectors.toMap(OrderFeeRateEntity::getDemension, a -> a, (k1, k2) -> k1));
        List dictDataVos = DictUtil.list((String)"order_fee_rate_demension");
        dictDataVos = dictDataVos.stream().sorted(Comparator.comparing(DictDataVo::getDictSort)).collect(Collectors.toList());
        for (DictDataVo dictDataVo : dictDataVos) {
            OrderFeeRateEntity entity = entityMap.get(dictDataVo.getDictCode());
            if (null == entity) continue;
            reBigdecimal = vo.getOrderMoney().multiply(entity.getRate()).divide(new BigDecimal(100), 6, 4);
            return reBigdecimal;
        }
        return reBigdecimal;
    }
}

